/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.netty;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.FutureUtils;
import io.servicetalk.grpc.api.GrpcBindableService;
import io.servicetalk.grpc.api.GrpcExceptionMapperServiceFilter;
import io.servicetalk.grpc.api.GrpcExecutionStrategies;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcFilters;
import io.servicetalk.grpc.api.GrpcLifecycleObserver;
import io.servicetalk.grpc.api.GrpcServerBuilder;
import io.servicetalk.grpc.api.GrpcServerContext;
import io.servicetalk.grpc.api.GrpcServiceFactory;
import io.servicetalk.grpc.netty.GrpcToHttpLifecycleObserverBridge;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.DelegatingHttpServerBuilder;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.netty.HttpProtocolConfigs;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.ExecutionContextBuilder;
import io.servicetalk.utils.internal.DurationUtils;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class DefaultGrpcServerBuilder
implements GrpcServerBuilder,
GrpcServiceFactory.ServerBinder {
    private final Supplier<HttpServerBuilder> httpServerBuilderSupplier;
    private GrpcServerBuilder.HttpInitializer initializer = builder -> {};
    private GrpcServerBuilder.HttpInitializer directCallInitializer = builder -> {};
    @Nullable
    private ExecutionContextInterceptorHttpServerBuilder interceptorBuilder;
    @Nullable
    private Duration defaultTimeout;
    private boolean appendTimeoutFilter = true;

    DefaultGrpcServerBuilder(Supplier<HttpServerBuilder> httpServerBuilderSupplier) {
        this.httpServerBuilderSupplier = () -> ((HttpServerBuilder)Objects.requireNonNull(httpServerBuilderSupplier.get(), "Supplier<HttpServerBuilder> result was null")).protocols(new HttpProtocolConfig[]{HttpProtocolConfigs.h2Default()}).allowDropRequestTrailers(true);
    }

    public GrpcServerBuilder initializeHttp(GrpcServerBuilder.HttpInitializer initializer) {
        this.initializer = Objects.requireNonNull(initializer);
        return this;
    }

    public GrpcServerBuilder defaultTimeout(Duration defaultTimeout) {
        this.defaultTimeout = DurationUtils.ensurePositive((Duration)defaultTimeout, (String)"defaultTimeout");
        return this;
    }

    public GrpcServerBuilder defaultTimeout(@Nullable Duration defaultTimeout, boolean appendTimeoutFilter) {
        this.defaultTimeout = defaultTimeout == null ? null : DurationUtils.ensurePositive((Duration)defaultTimeout, (String)"defaultTimeout");
        this.appendTimeoutFilter = appendTimeoutFilter;
        return this;
    }

    public GrpcServerBuilder lifecycleObserver(GrpcLifecycleObserver lifecycleObserver) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.lifecycleObserver((HttpLifecycleObserver)new GrpcToHttpLifecycleObserverBridge(lifecycleObserver)));
        return this;
    }

    public Single<GrpcServerContext> listen(GrpcBindableService<?> ... services) {
        GrpcServiceFactory[] factories = (GrpcServiceFactory[])Arrays.stream(services).map(GrpcBindableService::bindService).toArray(GrpcServiceFactory[]::new);
        return this.listen(factories);
    }

    public Single<GrpcServerContext> listen(GrpcServiceFactory<?> ... serviceFactories) {
        return this.doListen(GrpcServiceFactory.merge(serviceFactories));
    }

    public GrpcServerContext listenAndAwait(GrpcServiceFactory<?> ... serviceFactories) throws Exception {
        return (GrpcServerContext)FutureUtils.awaitResult((Future)this.listen(serviceFactories).toFuture());
    }

    public GrpcServerContext listenAndAwait(GrpcBindableService<?> ... services) throws Exception {
        GrpcServiceFactory[] factories = (GrpcServiceFactory[])Arrays.stream(services).map(GrpcBindableService::bindService).toArray(GrpcServiceFactory[]::new);
        return this.listenAndAwait(factories);
    }

    private Single<GrpcServerContext> doListen(GrpcServiceFactory<?> serviceFactory) {
        this.interceptorBuilder = this.preBuild();
        return serviceFactory.bind((GrpcServiceFactory.ServerBinder)this, this.interceptorBuilder.contextBuilder.build());
    }

    private ExecutionContextInterceptorHttpServerBuilder preBuild() {
        ExecutionContextInterceptorHttpServerBuilder interceptor = new ExecutionContextInterceptorHttpServerBuilder(this.httpServerBuilderSupplier.get());
        interceptor.appendNonOffloadingServiceFilter(GrpcExceptionMapperServiceFilter.INSTANCE);
        this.directCallInitializer.initialize((HttpServerBuilder)interceptor);
        if (this.appendTimeoutFilter) {
            interceptor.appendNonOffloadingServiceFilter(GrpcFilters.newGrpcDeadlineServerFilterFactory((Duration)this.defaultTimeout));
        }
        this.initializer.initialize((HttpServerBuilder)interceptor);
        return interceptor;
    }

    public Single<HttpServerContext> bind(HttpService service) {
        return this.interceptorBuilder.listen(service);
    }

    public Single<HttpServerContext> bindStreaming(StreamingHttpService service) {
        return this.interceptorBuilder.listenStreaming(service);
    }

    public Single<HttpServerContext> bindBlocking(BlockingHttpService service) {
        return this.interceptorBuilder.listenBlocking(service);
    }

    public Single<HttpServerContext> bindBlockingStreaming(BlockingStreamingHttpService service) {
        return this.interceptorBuilder.listenBlockingStreaming(service);
    }

    private static class ExecutionContextInterceptorHttpServerBuilder
    extends DelegatingHttpServerBuilder {
        private final ExecutionContextBuilder<GrpcExecutionStrategy> contextBuilder = new ExecutionContextBuilder().executionStrategy((ExecutionStrategy)GrpcExecutionStrategies.defaultStrategy());

        ExecutionContextInterceptorHttpServerBuilder(HttpServerBuilder delegate) {
            super(delegate);
        }

        public HttpServerBuilder ioExecutor(IoExecutor ioExecutor) {
            this.contextBuilder.ioExecutor(ioExecutor);
            this.delegate().ioExecutor(ioExecutor);
            return this;
        }

        public HttpServerBuilder executor(Executor executor) {
            this.contextBuilder.executor(executor);
            this.delegate().executor(executor);
            return this;
        }

        public HttpServerBuilder bufferAllocator(BufferAllocator allocator) {
            this.contextBuilder.bufferAllocator(allocator);
            this.delegate().bufferAllocator(allocator);
            return this;
        }

        public HttpServerBuilder executionStrategy(HttpExecutionStrategy strategy) {
            this.contextBuilder.executionStrategy((ExecutionStrategy)GrpcExecutionStrategy.from((HttpExecutionStrategy)strategy));
            this.delegate().executionStrategy(strategy);
            return this;
        }
    }
}

