/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.netty;

import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.grpc.api.GrpcClientBuilder;
import io.servicetalk.grpc.api.GrpcProviders;
import io.servicetalk.grpc.netty.DefaultGrpcClientBuilder;
import io.servicetalk.http.netty.HttpClients;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.utils.internal.ServiceLoaderUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcClients {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcClients.class);
    private static final List<GrpcProviders.GrpcClientBuilderProvider> PROVIDERS;

    private GrpcClients() {
    }

    private static <U, R> GrpcClientBuilder<U, R> applyProviders(U address, GrpcClientBuilder<U, R> builder) {
        for (GrpcProviders.GrpcClientBuilderProvider provider : PROVIDERS) {
            builder = provider.newBuilder(address, builder);
        }
        return builder;
    }

    public static GrpcClientBuilder<HostAndPort, InetSocketAddress> forAddress(String host, int port) {
        return GrpcClients.forAddress(HostAndPort.of((String)host, (int)port));
    }

    public static GrpcClientBuilder<HostAndPort, InetSocketAddress> forAddress(HostAndPort address) {
        return GrpcClients.applyProviders(address, new DefaultGrpcClientBuilder(() -> HttpClients.forSingleAddress((HostAndPort)address)));
    }

    public static GrpcClientBuilder<String, InetSocketAddress> forServiceAddress(String serviceName) {
        return GrpcClients.applyProviders(serviceName, new DefaultGrpcClientBuilder(() -> HttpClients.forServiceAddress((String)serviceName)));
    }

    public static GrpcClientBuilder<HostAndPort, InetSocketAddress> forResolvedAddress(String host, int port) {
        return GrpcClients.forResolvedAddress(HostAndPort.of((String)host, (int)port));
    }

    public static GrpcClientBuilder<HostAndPort, InetSocketAddress> forResolvedAddress(HostAndPort address) {
        return GrpcClients.applyProviders(address, new DefaultGrpcClientBuilder(() -> HttpClients.forResolvedAddress((HostAndPort)address)));
    }

    public static GrpcClientBuilder<InetSocketAddress, InetSocketAddress> forResolvedAddress(InetSocketAddress address) {
        return GrpcClients.applyProviders(address, new DefaultGrpcClientBuilder(() -> HttpClients.forResolvedAddress((SocketAddress)address)));
    }

    public static <T extends SocketAddress> GrpcClientBuilder<T, T> forResolvedAddress(T address) {
        return GrpcClients.applyProviders(address, new DefaultGrpcClientBuilder(() -> HttpClients.forResolvedAddress((SocketAddress)address)));
    }

    public static <U, R> GrpcClientBuilder<U, R> forAddress(ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer, U address) {
        return GrpcClients.applyProviders(address, new DefaultGrpcClientBuilder(() -> HttpClients.forSingleAddress((ServiceDiscoverer)serviceDiscoverer, (Object)address)));
    }

    static {
        ClassLoader classLoader = GrpcClients.class.getClassLoader();
        PROVIDERS = ServiceLoaderUtils.loadProviders(GrpcProviders.GrpcClientBuilderProvider.class, (ClassLoader)classLoader, (Logger)LOGGER);
    }
}

