/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.netty;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.TimeSource;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.FutureUtils;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.grpc.api.GrpcBindableService;
import io.servicetalk.grpc.api.GrpcExceptionMapperServiceFilter;
import io.servicetalk.grpc.api.GrpcExecutionStrategies;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcLifecycleObserver;
import io.servicetalk.grpc.api.GrpcServerBuilder;
import io.servicetalk.grpc.api.GrpcServerContext;
import io.servicetalk.grpc.api.GrpcServiceFactory;
import io.servicetalk.grpc.internal.DeadlineUtils;
import io.servicetalk.grpc.netty.GrpcToHttpLifecycleObserverBridge;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.netty.HttpProtocolConfigs;
import io.servicetalk.http.utils.TimeoutHttpServiceFilter;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ConnectionAcceptorFactory;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.ExecutionContextBuilder;
import io.servicetalk.utils.internal.DurationUtils;
import java.net.SocketOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultGrpcServerBuilder
implements GrpcServerBuilder,
GrpcServiceFactory.ServerBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGrpcServerBuilder.class);
    private final Supplier<HttpServerBuilder> httpServerBuilderSupplier;
    private GrpcServerBuilder.HttpInitializer initializer = builder -> {};
    private GrpcServerBuilder.HttpInitializer directCallInitializer = builder -> {};
    @Nullable
    private ExecutionContextInterceptorHttpServerBuilder interceptorBuilder;
    @Nullable
    private Duration defaultTimeout;

    DefaultGrpcServerBuilder(Supplier<HttpServerBuilder> httpServerBuilderSupplier) {
        this.httpServerBuilderSupplier = () -> ((HttpServerBuilder)Objects.requireNonNull(httpServerBuilderSupplier.get(), "Supplier<HttpServerBuilder> result was null")).protocols(new HttpProtocolConfig[]{HttpProtocolConfigs.h2Default()}).allowDropRequestTrailers(true);
    }

    public GrpcServerBuilder initializeHttp(GrpcServerBuilder.HttpInitializer initializer) {
        this.initializer = Objects.requireNonNull(initializer);
        return this;
    }

    public GrpcServerBuilder defaultTimeout(Duration defaultTimeout) {
        this.defaultTimeout = DurationUtils.ensurePositive((Duration)defaultTimeout, (String)"defaultTimeout");
        return this;
    }

    public GrpcServerBuilder lifecycleObserver(GrpcLifecycleObserver lifecycleObserver) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.lifecycleObserver((HttpLifecycleObserver)new GrpcToHttpLifecycleObserverBridge(lifecycleObserver)));
        return this;
    }

    public Single<GrpcServerContext> listen(GrpcBindableService<?> ... services) {
        GrpcServiceFactory[] factories = (GrpcServiceFactory[])Arrays.stream(services).map(GrpcBindableService::bindService).toArray(GrpcServiceFactory[]::new);
        return this.listen(factories);
    }

    public Single<GrpcServerContext> listen(GrpcServiceFactory<?> ... serviceFactories) {
        return this.doListen(GrpcServiceFactory.merge(serviceFactories));
    }

    public GrpcServerContext listenAndAwait(GrpcServiceFactory<?> ... serviceFactories) throws Exception {
        return (GrpcServerContext)FutureUtils.awaitResult((Future)this.listen(serviceFactories).toFuture());
    }

    public GrpcServerContext listenAndAwait(GrpcBindableService<?> ... services) throws Exception {
        GrpcServiceFactory[] factories = (GrpcServiceFactory[])Arrays.stream(services).map(GrpcBindableService::bindService).toArray(GrpcServiceFactory[]::new);
        return this.listenAndAwait(factories);
    }

    private Single<GrpcServerContext> doListen(GrpcServiceFactory<?> serviceFactory) {
        this.interceptorBuilder = this.preBuild();
        return serviceFactory.bind((GrpcServiceFactory.ServerBinder)this, this.interceptorBuilder.contextBuilder.build());
    }

    private ExecutionContextInterceptorHttpServerBuilder preBuild() {
        ExecutionContextInterceptorHttpServerBuilder interceptor = new ExecutionContextInterceptorHttpServerBuilder(this.httpServerBuilderSupplier.get());
        interceptor.appendNonOffloadingServiceFilter(GrpcExceptionMapperServiceFilter.INSTANCE);
        this.directCallInitializer.initialize((HttpServerBuilder)interceptor);
        this.initializer.initialize((HttpServerBuilder)interceptor);
        interceptor.appendServiceFilter((StreamingHttpServiceFilterFactory)new TimeoutHttpServiceFilter(DefaultGrpcServerBuilder.grpcDetermineTimeout(this.defaultTimeout), true));
        return interceptor;
    }

    private static BiFunction<HttpRequestMetaData, TimeSource, Duration> grpcDetermineTimeout(@Nullable Duration defaultTimeout) {
        return (request, timeSource) -> {
            Duration timeout;
            Duration requestTimeout = DeadlineUtils.readTimeoutHeader((HttpRequestMetaData)request);
            Duration duration = timeout = null != requestTimeout ? requestTimeout : defaultTimeout;
            if (null != timeout) {
                try {
                    Long deadline = timeSource.currentTime(TimeUnit.NANOSECONDS) + timeout.toNanos();
                    AsyncContext.put((ContextMap.Key)DeadlineUtils.GRPC_DEADLINE_KEY, (Object)deadline);
                }
                catch (UnsupportedOperationException ignored) {
                    LOGGER.debug("Async context disabled, timeouts will not be propagated to client requests");
                }
            }
            return timeout;
        };
    }

    public Single<HttpServerContext> bind(HttpService service) {
        return this.interceptorBuilder.listen(service);
    }

    public Single<HttpServerContext> bindStreaming(StreamingHttpService service) {
        return this.interceptorBuilder.listenStreaming(service);
    }

    public Single<HttpServerContext> bindBlocking(BlockingHttpService service) {
        return this.interceptorBuilder.listenBlocking(service);
    }

    public Single<HttpServerContext> bindBlockingStreaming(BlockingStreamingHttpService service) {
        return this.interceptorBuilder.listenBlockingStreaming(service);
    }

    private static class ExecutionContextInterceptorHttpServerBuilder
    implements HttpServerBuilder {
        private final HttpServerBuilder delegate;
        private final ExecutionContextBuilder<GrpcExecutionStrategy> contextBuilder = new ExecutionContextBuilder().executionStrategy((ExecutionStrategy)GrpcExecutionStrategies.defaultStrategy());

        ExecutionContextInterceptorHttpServerBuilder(HttpServerBuilder delegate) {
            this.delegate = delegate;
        }

        public HttpServerBuilder ioExecutor(IoExecutor ioExecutor) {
            this.contextBuilder.ioExecutor(ioExecutor);
            this.delegate.ioExecutor(ioExecutor);
            return this;
        }

        public HttpServerBuilder executor(Executor executor) {
            this.contextBuilder.executor(executor);
            this.delegate.executor(executor);
            return this;
        }

        public HttpServerBuilder bufferAllocator(BufferAllocator allocator) {
            this.contextBuilder.bufferAllocator(allocator);
            this.delegate.bufferAllocator(allocator);
            return this;
        }

        public HttpServerBuilder executionStrategy(HttpExecutionStrategy strategy) {
            this.contextBuilder.executionStrategy((ExecutionStrategy)GrpcExecutionStrategy.from((HttpExecutionStrategy)strategy));
            this.delegate.executionStrategy(strategy);
            return this;
        }

        public HttpServerBuilder protocols(HttpProtocolConfig ... protocols) {
            this.delegate.protocols(protocols);
            return this;
        }

        public HttpServerBuilder sslConfig(ServerSslConfig config) {
            this.delegate.sslConfig(config);
            return this;
        }

        public HttpServerBuilder sslConfig(ServerSslConfig defaultConfig, Map<String, ServerSslConfig> sniMap) {
            this.delegate.sslConfig(defaultConfig, sniMap);
            return this;
        }

        public <T> HttpServerBuilder socketOption(SocketOption<T> option, T value) {
            this.delegate.socketOption(option, value);
            return this;
        }

        public <T> HttpServerBuilder listenSocketOption(SocketOption<T> option, T value) {
            this.delegate.listenSocketOption(option, value);
            return this;
        }

        public HttpServerBuilder enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
            this.delegate.enableWireLogging(loggerName, logLevel, logUserData);
            return this;
        }

        public HttpServerBuilder transportObserver(TransportObserver transportObserver) {
            this.delegate.transportObserver(transportObserver);
            return this;
        }

        public HttpServerBuilder lifecycleObserver(HttpLifecycleObserver lifecycleObserver) {
            this.delegate.lifecycleObserver(lifecycleObserver);
            return this;
        }

        public HttpServerBuilder drainRequestPayloadBody(boolean enable) {
            this.delegate.drainRequestPayloadBody(enable);
            return this;
        }

        public HttpServerBuilder allowDropRequestTrailers(boolean allowDrop) {
            this.delegate.allowDropRequestTrailers(allowDrop);
            return this;
        }

        public HttpServerBuilder appendConnectionAcceptorFilter(ConnectionAcceptorFactory factory) {
            this.delegate.appendConnectionAcceptorFilter(factory);
            return this;
        }

        public HttpServerBuilder appendNonOffloadingServiceFilter(StreamingHttpServiceFilterFactory factory) {
            this.delegate.appendNonOffloadingServiceFilter(factory);
            return this;
        }

        public HttpServerBuilder appendNonOffloadingServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
            this.delegate.appendNonOffloadingServiceFilter(predicate, factory);
            return this;
        }

        public HttpServerBuilder appendServiceFilter(StreamingHttpServiceFilterFactory factory) {
            this.delegate.appendServiceFilter(factory);
            return this;
        }

        public HttpServerBuilder appendServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
            this.delegate.appendServiceFilter(predicate, factory);
            return this;
        }

        public Single<HttpServerContext> listen(HttpService service) {
            return this.delegate.listen(service);
        }

        public Single<HttpServerContext> listenStreaming(StreamingHttpService service) {
            return this.delegate.listenStreaming(service);
        }

        public Single<HttpServerContext> listenBlocking(BlockingHttpService service) {
            return this.delegate.listenBlocking(service);
        }

        public Single<HttpServerContext> listenBlockingStreaming(BlockingStreamingHttpService service) {
            return this.delegate.listenBlockingStreaming(service);
        }
    }
}

