/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.netty;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.grpc.api.GrpcExecutionStrategies;
import io.servicetalk.grpc.api.GrpcExecutionStrategy;
import io.servicetalk.grpc.api.GrpcLifecycleObserver;
import io.servicetalk.grpc.api.GrpcServerBuilder;
import io.servicetalk.grpc.api.GrpcServerSecurityConfigurator;
import io.servicetalk.grpc.api.GrpcServiceFactory;
import io.servicetalk.grpc.internal.DeadlineUtils;
import io.servicetalk.grpc.netty.GrpcToHttpLifecycleObserverBridge;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.HttpServerSecurityConfigurator;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.netty.HttpProtocolConfigs;
import io.servicetalk.http.utils.TimeoutFromRequest;
import io.servicetalk.http.utils.TimeoutHttpServiceFilter;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ConnectionAcceptor;
import io.servicetalk.transport.api.ConnectionAcceptorFactory;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.SecurityConfigurator;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.api.ServerSecurityConfigurator;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.ExecutionContextBuilder;
import io.servicetalk.utils.internal.DurationUtils;
import java.io.InputStream;
import java.net.SocketOption;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultGrpcServerBuilder
extends GrpcServerBuilder
implements GrpcServiceFactory.ServerBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGrpcServerBuilder.class);
    private final Supplier<HttpServerBuilder> httpServerBuilderSupplier;
    private GrpcServerBuilder.HttpInitializer initializer = builder -> {};
    private GrpcServerBuilder.HttpInitializer directCallInitializer = builder -> {};
    @Nullable
    private ExecutionContextInterceptorHttpServerBuilder interceptorBuilder;
    @Nullable
    private Duration defaultTimeout;

    DefaultGrpcServerBuilder(Supplier<HttpServerBuilder> httpServerBuilderSupplier) {
        this.httpServerBuilderSupplier = () -> ((HttpServerBuilder)httpServerBuilderSupplier.get()).protocols(new HttpProtocolConfig[]{HttpProtocolConfigs.h2Default()}).allowDropRequestTrailers(true);
    }

    public GrpcServerBuilder initializeHttp(GrpcServerBuilder.HttpInitializer initializer) {
        this.initializer = Objects.requireNonNull(initializer);
        return this;
    }

    public GrpcServerBuilder defaultTimeout(Duration defaultTimeout) {
        this.defaultTimeout = DurationUtils.ensurePositive((Duration)defaultTimeout, (String)"defaultTimeout");
        return this;
    }

    public GrpcServerBuilder protocols(HttpProtocolConfig ... protocols) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.protocols(protocols));
        return this;
    }

    @Deprecated
    public GrpcServerSecurityConfigurator secure() {
        return new LazyGrpcServerSecurityConfigurator();
    }

    public GrpcServerBuilder sslConfig(ServerSslConfig config) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.sslConfig(config));
        return this;
    }

    public GrpcServerBuilder sslConfig(ServerSslConfig defaultConfig, Map<String, ServerSslConfig> sniMap) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.sslConfig(defaultConfig, sniMap));
        return this;
    }

    public <T> GrpcServerBuilder socketOption(SocketOption<T> option, T value) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.socketOption(option, value));
        return this;
    }

    public <T> GrpcServerBuilder listenSocketOption(SocketOption<T> option, T value) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.listenSocketOption(option, value));
        return this;
    }

    @Deprecated
    public GrpcServerBuilder enableWireLogging(String loggerName) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.enableWireLogging(loggerName));
        return this;
    }

    public GrpcServerBuilder enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.enableWireLogging(loggerName, logLevel, logUserData));
        return this;
    }

    public GrpcServerBuilder transportObserver(TransportObserver transportObserver) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.transportObserver(transportObserver));
        return this;
    }

    public GrpcServerBuilder lifecycleObserver(GrpcLifecycleObserver lifecycleObserver) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.lifecycleObserver((HttpLifecycleObserver)new GrpcToHttpLifecycleObserverBridge(lifecycleObserver)));
        return this;
    }

    public GrpcServerBuilder drainRequestPayloadBody(boolean enable) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.drainRequestPayloadBody(enable));
        return this;
    }

    public GrpcServerBuilder appendConnectionAcceptorFilter(ConnectionAcceptorFactory factory) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.appendConnectionAcceptorFilter(factory));
        return this;
    }

    public GrpcServerBuilder executor(Executor executor) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.executor(executor));
        return this;
    }

    public GrpcServerBuilder ioExecutor(IoExecutor ioExecutor) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.ioExecutor(ioExecutor));
        return this;
    }

    public GrpcServerBuilder bufferAllocator(BufferAllocator allocator) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.bufferAllocator(allocator));
        return this;
    }

    public GrpcServerBuilder executionStrategy(GrpcExecutionStrategy strategy) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.executionStrategy((HttpExecutionStrategy)strategy));
        return this;
    }

    protected Single<ServerContext> doListen(GrpcServiceFactory<?, ?, ?> serviceFactory) {
        this.interceptorBuilder = this.preBuild();
        return serviceFactory.bind((GrpcServiceFactory.ServerBinder)this, this.interceptorBuilder.contextBuilder.build());
    }

    protected void doAppendHttpServiceFilter(StreamingHttpServiceFilterFactory factory) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.appendServiceFilter(factory));
    }

    protected void doAppendHttpServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
        this.directCallInitializer = this.directCallInitializer.append(builder -> builder.appendServiceFilter(predicate, factory));
    }

    private ExecutionContextInterceptorHttpServerBuilder preBuild() {
        ExecutionContextInterceptorHttpServerBuilder interceptor = new ExecutionContextInterceptorHttpServerBuilder(this.httpServerBuilderSupplier.get());
        DefaultGrpcServerBuilder.appendCatchAllFilter((HttpServerBuilder)interceptor);
        this.directCallInitializer.initialize((HttpServerBuilder)interceptor);
        this.initializer.initialize((HttpServerBuilder)interceptor);
        interceptor.appendServiceFilter((StreamingHttpServiceFilterFactory)new TimeoutHttpServiceFilter(DefaultGrpcServerBuilder.grpcDetermineTimeout(this.defaultTimeout), true));
        return interceptor;
    }

    private static TimeoutFromRequest grpcDetermineTimeout(final @Nullable Duration defaultTimeout) {
        return new TimeoutFromRequest(){

            @Nullable
            public Duration apply(HttpRequestMetaData request) {
                Duration timeout;
                Duration requestTimeout = DeadlineUtils.readTimeoutHeader((HttpRequestMetaData)request);
                Duration duration = timeout = null != requestTimeout ? requestTimeout : defaultTimeout;
                if (null != timeout) {
                    try {
                        Long deadline = System.nanoTime() + timeout.toNanos();
                        AsyncContext.put((AsyncContextMap.Key)GRPC_DEADLINE_KEY, (Object)deadline);
                    }
                    catch (UnsupportedOperationException ignored) {
                        LOGGER.debug("Async context disabled, timeouts will not be propagated to client requests");
                    }
                }
                return timeout;
            }

            public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
                return strategy;
            }
        };
    }

    public Single<ServerContext> bind(HttpService service) {
        return this.interceptorBuilder.listen(service);
    }

    public Single<ServerContext> bindStreaming(StreamingHttpService service) {
        return this.interceptorBuilder.listenStreaming(service);
    }

    public Single<ServerContext> bindBlocking(BlockingHttpService service) {
        return this.interceptorBuilder.listenBlocking(service);
    }

    public Single<ServerContext> bindBlockingStreaming(BlockingStreamingHttpService service) {
        return this.interceptorBuilder.listenBlockingStreaming(service);
    }

    private static class ExecutionContextInterceptorHttpServerBuilder
    extends HttpServerBuilder {
        private final HttpServerBuilder delegate;
        private final ExecutionContextBuilder contextBuilder = new ExecutionContextBuilder().executionStrategy((ExecutionStrategy)GrpcExecutionStrategies.defaultStrategy());

        ExecutionContextInterceptorHttpServerBuilder(HttpServerBuilder delegate) {
            this.delegate = delegate;
        }

        protected Single<ServerContext> doListen(@Nullable ConnectionAcceptor connectionAcceptor, StreamingHttpService service, HttpExecutionStrategy strategy, boolean drainRequestPayloadBody) {
            throw new UnsupportedOperationException("This delegate builder does not create the ServerContext");
        }

        public HttpServerBuilder executor(Executor executor) {
            this.contextBuilder.executor(executor);
            this.delegate.executor(executor);
            return this;
        }

        public HttpServerBuilder ioExecutor(IoExecutor ioExecutor) {
            this.contextBuilder.ioExecutor(ioExecutor);
            this.delegate.ioExecutor(ioExecutor);
            return this;
        }

        public HttpServerBuilder executionStrategy(HttpExecutionStrategy strategy) {
            this.contextBuilder.executionStrategy((ExecutionStrategy)strategy);
            this.delegate.executionStrategy(strategy);
            return this;
        }

        public HttpServerBuilder bufferAllocator(BufferAllocator allocator) {
            this.contextBuilder.bufferAllocator(allocator);
            this.delegate.bufferAllocator(allocator);
            return this;
        }

        public HttpServerBuilder protocols(HttpProtocolConfig ... protocols) {
            this.delegate.protocols(protocols);
            return this;
        }

        public HttpServerSecurityConfigurator secure() {
            return this.delegate.secure();
        }

        public HttpServerBuilder sslConfig(ServerSslConfig config) {
            this.delegate.sslConfig(config);
            return this;
        }

        public HttpServerBuilder sslConfig(ServerSslConfig defaultConfig, Map<String, ServerSslConfig> sniMap) {
            this.delegate.sslConfig(defaultConfig, sniMap);
            return this;
        }

        public <T> HttpServerBuilder socketOption(SocketOption<T> option, T value) {
            this.delegate.socketOption(option, value);
            return this;
        }

        public <T> HttpServerBuilder listenSocketOption(SocketOption<T> option, T value) {
            this.delegate.listenSocketOption(option, value);
            return this;
        }

        public HttpServerBuilder enableWireLogging(String loggerName) {
            this.delegate.enableWireLogging(loggerName);
            return this;
        }

        public HttpServerBuilder enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
            this.delegate.enableWireLogging(loggerName, logLevel, logUserData);
            return this;
        }

        public HttpServerBuilder transportObserver(TransportObserver transportObserver) {
            this.delegate.transportObserver(transportObserver);
            return this;
        }

        public HttpServerBuilder allowDropRequestTrailers(boolean allowDrop) {
            this.delegate.allowDropRequestTrailers(allowDrop);
            return this;
        }

        public HttpServerBuilder backlog(int backlog) {
            this.delegate.backlog(backlog);
            return this;
        }

        public HttpServerBuilder lifecycleObserver(HttpLifecycleObserver lifecycleObserver) {
            this.delegate.lifecycleObserver(lifecycleObserver);
            return this;
        }

        public HttpServerBuilder disableDrainingRequestPayloadBody() {
            this.delegate.disableDrainingRequestPayloadBody();
            return this;
        }

        public HttpServerBuilder drainRequestPayloadBody(boolean enable) {
            this.delegate.drainRequestPayloadBody(enable);
            return this;
        }

        public HttpServerBuilder appendConnectionAcceptorFilter(ConnectionAcceptorFactory factory) {
            this.delegate.appendConnectionAcceptorFilter(factory);
            return this;
        }

        public HttpServerBuilder appendServiceFilter(StreamingHttpServiceFilterFactory factory) {
            this.delegate.appendServiceFilter(factory);
            return this;
        }

        public HttpServerBuilder appendServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
            this.delegate.appendServiceFilter(predicate, factory);
            return this;
        }

        public ServerContext listenAndAwait(HttpService service) throws Exception {
            return this.delegate.listenAndAwait(service);
        }

        public ServerContext listenStreamingAndAwait(StreamingHttpService handler) throws Exception {
            return this.delegate.listenStreamingAndAwait(handler);
        }

        public ServerContext listenBlockingAndAwait(BlockingHttpService service) throws Exception {
            return this.delegate.listenBlockingAndAwait(service);
        }

        public ServerContext listenBlockingStreamingAndAwait(BlockingStreamingHttpService handler) throws Exception {
            return this.delegate.listenBlockingStreamingAndAwait(handler);
        }

        public Single<ServerContext> listen(HttpService service) {
            return this.delegate.listen(service);
        }

        public Single<ServerContext> listenStreaming(StreamingHttpService service) {
            return this.delegate.listenStreaming(service);
        }

        public Single<ServerContext> listenBlocking(BlockingHttpService service) {
            return this.delegate.listenBlocking(service);
        }

        public Single<ServerContext> listenBlockingStreaming(BlockingStreamingHttpService service) {
            return this.delegate.listenBlockingStreaming(service);
        }
    }

    private class LazyGrpcServerSecurityConfigurator
    implements GrpcServerSecurityConfigurator {
        @Nullable
        private HttpServerSecurityConfigurator delegate;
        private GrpcServerBuilder.HttpInitializer initializer = builder -> {
            this.delegate = Objects.requireNonNull(builder.secure());
        };

        private LazyGrpcServerSecurityConfigurator() {
        }

        public GrpcServerSecurityConfigurator trustManager(Supplier<InputStream> trustCertChainSupplier) {
            this.initializer = this.initializer.append(builder -> this.delegate.trustManager(trustCertChainSupplier));
            return this;
        }

        public GrpcServerSecurityConfigurator trustManager(TrustManagerFactory trustManagerFactory) {
            this.initializer = this.initializer.append(builder -> this.delegate.trustManager(trustManagerFactory));
            return this;
        }

        public GrpcServerSecurityConfigurator protocols(String ... protocols) {
            this.initializer = this.initializer.append(builder -> this.delegate.protocols(protocols));
            return this;
        }

        public GrpcServerSecurityConfigurator ciphers(Iterable<String> ciphers) {
            this.initializer = this.initializer.append(builder -> this.delegate.ciphers(ciphers));
            return this;
        }

        public GrpcServerSecurityConfigurator sessionCacheSize(long sessionCacheSize) {
            this.initializer = this.initializer.append(builder -> this.delegate.sessionCacheSize(sessionCacheSize));
            return this;
        }

        public GrpcServerSecurityConfigurator sessionTimeout(long sessionTimeout) {
            this.initializer = this.initializer.append(builder -> this.delegate.sessionTimeout(sessionTimeout));
            return this;
        }

        public GrpcServerSecurityConfigurator provider(SecurityConfigurator.SslProvider provider) {
            this.initializer = this.initializer.append(builder -> this.delegate.provider(provider));
            return this;
        }

        public GrpcServerSecurityConfigurator clientAuth(ServerSecurityConfigurator.ClientAuth clientAuth) {
            this.initializer = this.initializer.append(builder -> this.delegate.clientAuth(clientAuth));
            return this;
        }

        public GrpcServerBuilder commit(KeyManagerFactory keyManagerFactory) {
            this.initializer = this.initializer.append(builder -> this.delegate.commit(keyManagerFactory));
            DefaultGrpcServerBuilder.this.directCallInitializer = DefaultGrpcServerBuilder.this.directCallInitializer.append(this.initializer);
            return DefaultGrpcServerBuilder.this;
        }

        public GrpcServerBuilder commit(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier) {
            this.initializer = this.initializer.append(builder -> this.delegate.commit(keyCertChainSupplier, keySupplier));
            DefaultGrpcServerBuilder.this.directCallInitializer = DefaultGrpcServerBuilder.this.directCallInitializer.append(this.initializer);
            return DefaultGrpcServerBuilder.this;
        }

        public GrpcServerBuilder commit(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier, String keyPassword) {
            this.initializer = this.initializer.append(builder -> this.delegate.commit(keyCertChainSupplier, keySupplier, keyPassword));
            DefaultGrpcServerBuilder.this.directCallInitializer = DefaultGrpcServerBuilder.this.directCallInitializer.append(this.initializer);
            return DefaultGrpcServerBuilder.this;
        }
    }
}

