/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.grpc.netty;

import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.grpc.api.GrpcClientBuilder;
import io.servicetalk.grpc.netty.DefaultGrpcClientBuilder;
import io.servicetalk.http.netty.HttpClients;
import io.servicetalk.transport.api.HostAndPort;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class GrpcClients {
    private GrpcClients() {
    }

    public static GrpcClientBuilder<HostAndPort, InetSocketAddress> forAddress(String host, int port) {
        return new DefaultGrpcClientBuilder<HostAndPort, InetSocketAddress>(HttpClients.forSingleAddress((String)host, (int)port));
    }

    public static GrpcClientBuilder<HostAndPort, InetSocketAddress> forAddress(HostAndPort address) {
        return new DefaultGrpcClientBuilder<HostAndPort, InetSocketAddress>(HttpClients.forSingleAddress((HostAndPort)address));
    }

    public static GrpcClientBuilder<String, InetSocketAddress> forServiceAddress(String serviceName) {
        return new DefaultGrpcClientBuilder<String, InetSocketAddress>(HttpClients.forServiceAddress((String)serviceName));
    }

    public static GrpcClientBuilder<HostAndPort, InetSocketAddress> forResolvedAddress(String host, int port) {
        return new DefaultGrpcClientBuilder<HostAndPort, InetSocketAddress>(HttpClients.forResolvedAddress((String)host, (int)port));
    }

    public static GrpcClientBuilder<HostAndPort, InetSocketAddress> forResolvedAddress(HostAndPort address) {
        return new DefaultGrpcClientBuilder<HostAndPort, InetSocketAddress>(HttpClients.forResolvedAddress((HostAndPort)address));
    }

    public static GrpcClientBuilder<InetSocketAddress, InetSocketAddress> forResolvedAddress(InetSocketAddress address) {
        return new DefaultGrpcClientBuilder<InetSocketAddress, InetSocketAddress>(HttpClients.forResolvedAddress((SocketAddress)address));
    }

    public static <T extends SocketAddress> GrpcClientBuilder<T, T> forResolvedAddress(T address) {
        return new DefaultGrpcClientBuilder(HttpClients.forResolvedAddress(address));
    }

    public static <U, R> GrpcClientBuilder<U, R> forAddress(ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer, U address) {
        return new DefaultGrpcClientBuilder(HttpClients.forSingleAddress(serviceDiscoverer, address));
    }
}

