/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.encoding.netty;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.encoding.api.BufferEncoderDecoder;
import io.servicetalk.serializer.api.Deserializer;
import io.servicetalk.serializer.api.Serializer;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.serializer.api.StreamingDeserializer;
import io.servicetalk.serializer.api.StreamingSerializer;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;
import java.util.Objects;

final class DefaultBufferEncoderDecoder
implements BufferEncoderDecoder {
    private final SerializerDeserializer<Buffer> compressor;
    private final StreamingSerializerDeserializer<Buffer> streamingCompressor;
    private final CharSequence encodingName;

    DefaultBufferEncoderDecoder(SerializerDeserializer<Buffer> compressor, StreamingSerializerDeserializer<Buffer> streamingCompressor, CharSequence encodingName) {
        this.compressor = Objects.requireNonNull(compressor);
        this.streamingCompressor = Objects.requireNonNull(streamingCompressor);
        this.encodingName = Objects.requireNonNull(encodingName);
    }

    public Serializer<Buffer> encoder() {
        return this.compressor;
    }

    public StreamingSerializer<Buffer> streamingEncoder() {
        return this.streamingCompressor;
    }

    public Deserializer<Buffer> decoder() {
        return this.compressor;
    }

    public StreamingDeserializer<Buffer> streamingDecoder() {
        return this.streamingCompressor;
    }

    public CharSequence encodingName() {
        return this.encodingName;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof DefaultBufferEncoderDecoder && CharSequences.contentEqualsIgnoreCase((CharSequence)this.encodingName(), (CharSequence)((DefaultBufferEncoderDecoder)o).encodingName());
    }

    public int hashCode() {
        return CharSequences.caseInsensitiveHashCode((CharSequence)this.encodingName);
    }

    public String toString() {
        return this.encodingName.toString();
    }
}

