/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.DnsNameResolverBuilder;

public enum DnsResolverAddressTypes {
    IPV4_ONLY,
    IPV6_ONLY,
    IPV4_PREFERRED,
    IPV6_PREFERRED,
    IPV4_PREFERRED_RETURN_ALL,
    IPV6_PREFERRED_RETURN_ALL;


    static DnsResolverAddressTypes systemDefault() {
        return DnsResolverAddressTypes.fromNettyType(DnsNameResolverBuilder.computeResolvedAddressTypes((InternetProtocolFamily[])new InternetProtocolFamily[0]));
    }

    private static DnsResolverAddressTypes fromNettyType(ResolvedAddressTypes resolvedAddressType) {
        switch (resolvedAddressType) {
            case IPV4_ONLY: {
                return IPV4_ONLY;
            }
            case IPV6_ONLY: {
                return IPV6_ONLY;
            }
            case IPV4_PREFERRED: {
                return IPV4_PREFERRED;
            }
            case IPV6_PREFERRED: {
                return IPV6_PREFERRED;
            }
        }
        throw new IllegalArgumentException("Unknown value for " + ResolvedAddressTypes.class.getName() + ": " + resolvedAddressType);
    }

    static ResolvedAddressTypes toNettyType(DnsResolverAddressTypes dnsResolverAddressType) {
        switch (dnsResolverAddressType) {
            case IPV4_ONLY: {
                return ResolvedAddressTypes.IPV4_ONLY;
            }
            case IPV6_ONLY: {
                return ResolvedAddressTypes.IPV6_ONLY;
            }
            case IPV4_PREFERRED: 
            case IPV4_PREFERRED_RETURN_ALL: {
                return ResolvedAddressTypes.IPV4_PREFERRED;
            }
            case IPV6_PREFERRED: 
            case IPV6_PREFERRED_RETURN_ALL: {
                return ResolvedAddressTypes.IPV6_PREFERRED;
            }
        }
        throw new IllegalArgumentException("Unknown value for " + DnsResolverAddressTypes.class.getName() + ": " + (Object)((Object)dnsResolverAddressType));
    }
}

