/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.servicetalk.client.api.DefaultServiceDiscovererEvent;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.dns.discovery.netty.DnsClient;
import io.servicetalk.transport.api.HostAndPort;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

final class DnsClients {
    private DnsClients() {
    }

    static ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> asSrvDiscoverer(final DnsClient dns) {
        return new ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>>(){

            public Completable closeAsync() {
                return dns.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return dns.closeAsyncGracefully();
            }

            public Completable onClose() {
                return dns.onClose();
            }

            public Publisher<Collection<ServiceDiscovererEvent<InetSocketAddress>>> discover(String s) {
                return dns.dnsSrvQuery(s);
            }
        };
    }

    static ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> asHostAndPortDiscoverer(final DnsClient dns) {
        return new ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>>(){

            public Completable closeAsync() {
                return dns.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return dns.closeAsyncGracefully();
            }

            public Completable onClose() {
                return dns.onClose();
            }

            public Publisher<Collection<ServiceDiscovererEvent<InetSocketAddress>>> discover(HostAndPort hostAndPort) {
                return dns.dnsQuery(hostAndPort.hostName()).map(events -> DnsClients.mapEventList(events, inetAddress -> new InetSocketAddress((InetAddress)inetAddress, hostAndPort.port())));
            }
        };
    }

    static <T, R> List<ServiceDiscovererEvent<R>> mapEventList(Collection<ServiceDiscovererEvent<T>> original, Function<T, R> mapper) {
        return original.stream().map(evt -> new DefaultServiceDiscovererEvent(mapper.apply(evt.address()), evt.isAvailable())).collect(Collectors.toList());
    }
}

