/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.netty.resolver.dns.DnsNameResolverTimeoutException;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.dns.discovery.netty.DefaultDnsClient;
import io.servicetalk.dns.discovery.netty.DnsClient;
import io.servicetalk.dns.discovery.netty.DnsClientFilterFactory;
import io.servicetalk.dns.discovery.netty.DnsClients;
import io.servicetalk.dns.discovery.netty.DnsResolverAddressTypes;
import io.servicetalk.dns.discovery.netty.DnsServerAddressStreamProvider;
import io.servicetalk.dns.discovery.netty.DnsServiceDiscovererObserver;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.GlobalExecutionContext;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class DefaultDnsServiceDiscovererBuilder {
    @Nullable
    private DnsServerAddressStreamProvider dnsServerAddressStreamProvider;
    @Nullable
    private DnsResolverAddressTypes dnsResolverAddressTypes;
    @Nullable
    private Integer ndots;
    private Predicate<Throwable> invalidateHostsOnDnsFailure = DefaultDnsServiceDiscovererBuilder.defaultInvalidateHostsOnDnsFailurePredicate();
    @Nullable
    private Boolean optResourceEnabled;
    @Nullable
    private IoExecutor ioExecutor;
    @Nullable
    private Duration queryTimeout;
    private int minTTLSeconds = 10;
    @Nullable
    private DnsClientFilterFactory filterFactory;
    @Nullable
    private DnsServiceDiscovererObserver observer;

    public DefaultDnsServiceDiscovererBuilder minTTL(int minTTLSeconds) {
        if (minTTLSeconds < 1) {
            throw new IllegalArgumentException("minTTLSeconds: " + minTTLSeconds + " (expected > 1)");
        }
        this.minTTLSeconds = minTTLSeconds;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder dnsServerAddressStreamProvider(@Nullable DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        this.dnsServerAddressStreamProvider = dnsServerAddressStreamProvider;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder optResourceEnabled(boolean optResourceEnabled) {
        this.optResourceEnabled = optResourceEnabled;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder ndots(int ndots) {
        this.ndots = ndots;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder queryTimeout(Duration queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder invalidateHostsOnDnsFailure(Predicate<Throwable> invalidateHostsOnDnsFailure) {
        this.invalidateHostsOnDnsFailure = invalidateHostsOnDnsFailure;
        return this;
    }

    public static Predicate<Throwable> defaultInvalidateHostsOnDnsFailurePredicate() {
        return t -> t instanceof UnknownHostException && !(t.getCause() instanceof DnsNameResolverTimeoutException);
    }

    public DefaultDnsServiceDiscovererBuilder dnsResolverAddressTypes(@Nullable DnsResolverAddressTypes dnsResolverAddressTypes) {
        this.dnsResolverAddressTypes = dnsResolverAddressTypes;
        return this;
    }

    DefaultDnsServiceDiscovererBuilder appendFilter(DnsClientFilterFactory factory) {
        this.filterFactory = this.filterFactory == null ? Objects.requireNonNull(factory) : this.filterFactory.append(factory);
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder ioExecutor(IoExecutor ioExecutor) {
        this.ioExecutor = ioExecutor;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder observer(DnsServiceDiscovererObserver observer) {
        this.observer = Objects.requireNonNull(observer);
        return this;
    }

    public ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> buildSrvDiscoverer() {
        return DnsClients.asSrvDiscoverer(this.build());
    }

    public ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> buildARecordDiscoverer() {
        return DnsClients.asHostAndPortDiscoverer(this.build());
    }

    DnsClient build() {
        DefaultDnsClient rawClient = new DefaultDnsClient(this.ioExecutor == null ? GlobalExecutionContext.globalExecutionContext().ioExecutor() : this.ioExecutor, this.minTTLSeconds, this.ndots, this.invalidateHostsOnDnsFailure, this.optResourceEnabled, this.queryTimeout, this.dnsResolverAddressTypes, this.dnsServerAddressStreamProvider, this.observer);
        return this.filterFactory == null ? rawClient : this.filterFactory.create(rawClient);
    }
}

