/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRecordDecoder;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.servicetalk.client.api.DefaultServiceDiscovererEvent;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.client.api.internal.ServiceDiscovererUtils;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.SubscribablePublisher;
import io.servicetalk.concurrent.internal.DuplicateSubscribeException;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.RejectedSubscribeError;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.dns.discovery.netty.DefaultResolutionResult;
import io.servicetalk.dns.discovery.netty.DnsClient;
import io.servicetalk.dns.discovery.netty.DnsResolverAddressTypes;
import io.servicetalk.dns.discovery.netty.DnsServerAddressStream;
import io.servicetalk.dns.discovery.netty.DnsServerAddressStreamProvider;
import io.servicetalk.dns.discovery.netty.DnsServiceDiscovererObserver;
import io.servicetalk.dns.discovery.netty.MinTtlCache;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.BuilderUtils;
import io.servicetalk.transport.netty.internal.EventLoopAwareNettyIoExecutor;
import io.servicetalk.transport.netty.internal.EventLoopAwareNettyIoExecutors;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultDnsClient
implements DnsClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDnsClient.class);
    private static final Comparator<InetAddress> INET_ADDRESS_COMPARATOR = Comparator.comparing(o -> ByteBuffer.wrap(o.getAddress()));
    private static final Comparator<HostAndPort> HOST_AND_PORT_COMPARATOR = Comparator.comparing(HostAndPort::hostName).thenComparingInt(HostAndPort::port);
    private static final Cancellable TERMINATED = () -> {};
    private static final Cancellable TERMINATE_ON_NEXT_REQUEST_N = () -> {};
    private final EventLoopAwareNettyIoExecutor nettyIoExecutor;
    private final DnsNameResolver resolver;
    private final MinTtlCache ttlCache;
    private final Predicate<Throwable> invalidateHostsOnDnsFailure;
    private final ListenableAsyncCloseable asyncCloseable;
    @Nullable
    private final DnsServiceDiscovererObserver observer;
    private boolean closed;

    DefaultDnsClient(IoExecutor ioExecutor, int minTTL, @Nullable Integer ndots, Predicate<Throwable> invalidateHostsOnDnsFailure, @Nullable Boolean optResourceEnabled, @Nullable Duration queryTimeout, @Nullable DnsResolverAddressTypes dnsResolverAddressTypes, @Nullable DnsServerAddressStreamProvider dnsServerAddressStreamProvider, @Nullable DnsServiceDiscovererObserver observer) {
        this.nettyIoExecutor = EventLoopAwareNettyIoExecutors.toEventLoopAwareNettyIoExecutor((IoExecutor)ioExecutor).next();
        this.ttlCache = new MinTtlCache((DnsCache)new DefaultDnsCache(minTTL, Integer.MAX_VALUE, minTTL), minTTL);
        this.invalidateHostsOnDnsFailure = invalidateHostsOnDnsFailure;
        this.observer = observer;
        this.asyncCloseable = AsyncCloseables.toAsyncCloseable(graceful -> {
            if (this.nettyIoExecutor.isCurrentThreadEventLoop()) {
                this.closeAsync0();
                return Completable.completed();
            }
            return this.nettyIoExecutor.asExecutor().submit(this::closeAsync0);
        });
        EventLoop eventLoop = this.nettyIoExecutor.eventLoopGroup().next();
        Class socketChannelClass = BuilderUtils.socketChannel((EventLoopGroup)eventLoop, InetSocketAddress.class);
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder(eventLoop).resolveCache((DnsCache)this.ttlCache).channelType(BuilderUtils.datagramChannel((EventLoopGroup)eventLoop)).socketChannelType(socketChannelClass).completeOncePreferredResolved(true);
        if (queryTimeout != null) {
            builder.queryTimeoutMillis(queryTimeout.toMillis());
        }
        if (ndots != null) {
            builder.ndots(ndots.intValue());
        }
        if (optResourceEnabled != null) {
            builder.optResourceEnabled(optResourceEnabled.booleanValue());
        }
        if (dnsServerAddressStreamProvider != null) {
            builder.nameServerProvider(DefaultDnsClient.toNettyType(dnsServerAddressStreamProvider));
        }
        if (dnsResolverAddressTypes != null) {
            builder.resolvedAddressTypes(DefaultDnsClient.toNettyType(dnsResolverAddressTypes));
        }
        this.resolver = builder.build();
    }

    @Nullable
    private DnsServiceDiscovererObserver.DnsDiscoveryObserver newDiscoveryObserver(String address) {
        if (this.observer == null) {
            return null;
        }
        try {
            return this.observer.onNewDiscovery(address);
        }
        catch (Throwable unexpected) {
            LOGGER.warn("Unexpected exception from {} while reporting new DNS discovery for {}", new Object[]{this.observer, address, unexpected});
            return null;
        }
    }

    @Override
    public Publisher<ServiceDiscovererEvent<InetAddress>> dnsQuery(String address) {
        Objects.requireNonNull(address);
        return Publisher.defer(() -> new ARecordPublisher(true, address, this.newDiscoveryObserver(address)).flatMapConcatIterable(Function.identity()));
    }

    @Override
    public Publisher<ServiceDiscovererEvent<InetSocketAddress>> dnsSrvQuery(String serviceName) {
        Objects.requireNonNull(serviceName);
        return Publisher.defer(() -> {
            HashMap aRecordMap = new HashMap(8);
            DnsServiceDiscovererObserver.DnsDiscoveryObserver discoveryObserver = this.newDiscoveryObserver(serviceName);
            return new SrvRecordPublisher(serviceName, discoveryObserver).flatMapConcatIterable(Function.identity()).flatMapMergeSingle(srvEvent -> {
                List list;
                this.assertInEventloop();
                if (srvEvent.isAvailable()) {
                    ARecordPublisher aPublisher = new ARecordPublisher(false, ((HostAndPort)srvEvent.address()).hostName(), discoveryObserver);
                    ARecordPublisher prevAPublisher = aRecordMap.putIfAbsent(srvEvent.address(), aPublisher);
                    if (prevAPublisher != null) {
                        return Single.failed((Throwable)new IllegalStateException("Only 1 A* record per SRV record is supported. " + srvEvent.address() + " corresponding to SRV name " + serviceName + " had a pre-existing A* record:" + prevAPublisher.name + " when new A* record arrived: " + aPublisher.name));
                    }
                    return DefaultDnsClient.srvARecordPubToSingle((Publisher<Iterable<ServiceDiscovererEvent<InetAddress>>>)aPublisher, (ServiceDiscovererEvent<HostAndPort>)srvEvent, serviceName);
                }
                ARecordPublisher aPublisher = (ARecordPublisher)((Object)((Object)((Object)aRecordMap.remove(srvEvent.address()))));
                if (aPublisher != null && (list = aPublisher.close0()) != null) {
                    return DefaultDnsClient.srvARecordPubToSingle((Publisher<Iterable<ServiceDiscovererEvent<InetAddress>>>)Publisher.from(list), (ServiceDiscovererEvent<HostAndPort>)srvEvent, serviceName);
                }
                return Single.failed((Throwable)new IllegalStateException("Received an SRV inactive event for " + srvEvent.address() + " corresponding to SRV name " + serviceName + " but failed to find the corresponding A* record Publisher."));
            });
        });
    }

    private static Single<? extends ServiceDiscovererEvent<InetSocketAddress>> srvARecordPubToSingle(Publisher<Iterable<ServiceDiscovererEvent<InetAddress>>> aRecordPublisher, ServiceDiscovererEvent<HostAndPort> srvEvent, String serviceName) {
        return aRecordPublisher.flatMapConcatIterable(Function.identity()).map(inetEvent -> new DefaultServiceDiscovererEvent((Object)new InetSocketAddress((InetAddress)inetEvent.address(), ((HostAndPort)srvEvent.address()).port()), inetEvent.isAvailable())).firstOrElse(() -> {
            LOGGER.info("No A* records found for {} corresponding to SRV name {}", srvEvent.address(), (Object)serviceName);
            return null;
        });
    }

    public Completable onClose() {
        return this.asyncCloseable.onClose();
    }

    public Completable closeAsync() {
        return this.asyncCloseable.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.asyncCloseable.closeAsyncGracefully();
    }

    private void closeAsync0() {
        this.assertInEventloop();
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.resolver.close();
        this.ttlCache.clear();
    }

    private void assertInEventloop() {
        assert (this.nettyIoExecutor.isCurrentThreadEventLoop()) : "Must be called from the associated eventloop.";
    }

    private static ResolvedAddressTypes toNettyType(DnsResolverAddressTypes dnsResolverAddressTypes) {
        switch (dnsResolverAddressTypes) {
            case IPV4_ONLY: {
                return ResolvedAddressTypes.IPV4_ONLY;
            }
            case IPV6_ONLY: {
                return ResolvedAddressTypes.IPV6_ONLY;
            }
            case IPV6_PREFERRED: {
                return ResolvedAddressTypes.IPV6_PREFERRED;
            }
            case IPV4_PREFERRED: {
                return ResolvedAddressTypes.IPV4_PREFERRED;
            }
        }
        throw new Error();
    }

    private static io.netty.resolver.dns.DnsServerAddressStreamProvider toNettyType(DnsServerAddressStreamProvider provider) {
        return hostname -> new ServiceTalkToNettyDnsServerAddressStream(provider.nameServerAddressStream(hostname));
    }

    private static final class ClosedServiceDiscovererException
    extends RuntimeException
    implements RejectedSubscribeError {
        ClosedServiceDiscovererException(String message) {
            super(message);
        }
    }

    private static final class ServiceTalkToNettyDnsServerAddressStream
    implements io.netty.resolver.dns.DnsServerAddressStream {
        private final DnsServerAddressStream stream;

        ServiceTalkToNettyDnsServerAddressStream(DnsServerAddressStream stream) {
            this.stream = stream;
        }

        public InetSocketAddress next() {
            return this.stream.next();
        }

        public int size() {
            return this.stream.size();
        }

        public io.netty.resolver.dns.DnsServerAddressStream duplicate() {
            return new ServiceTalkToNettyDnsServerAddressStream(this.stream.duplicate());
        }
    }

    private abstract class AbstractDnsPublisher<T>
    extends SubscribablePublisher<Iterable<ServiceDiscovererEvent<T>>> {
        protected final String name;
        @Nullable
        protected final DnsServiceDiscovererObserver.DnsDiscoveryObserver discoveryObserver;
        @Nullable
        private AbstractDnsSubscription subscription;

        AbstractDnsPublisher(@Nullable String name, DnsServiceDiscovererObserver.DnsDiscoveryObserver discoveryObserver) {
            this.name = name;
            this.discoveryObserver = discoveryObserver;
        }

        protected abstract AbstractDnsSubscription newSubscription(PublisherSource.Subscriber<? super Iterable<ServiceDiscovererEvent<T>>> var1);

        protected final void handleSubscribe(PublisherSource.Subscriber<? super Iterable<ServiceDiscovererEvent<T>>> subscriber) {
            if (DefaultDnsClient.this.nettyIoExecutor.isCurrentThreadEventLoop()) {
                this.handleSubscribe0(subscriber);
            } else {
                DefaultDnsClient.this.nettyIoExecutor.asExecutor().execute(() -> this.handleSubscribe0(subscriber));
            }
        }

        private void handleSubscribe0(PublisherSource.Subscriber<? super Iterable<ServiceDiscovererEvent<T>>> subscriber) {
            DefaultDnsClient.this.assertInEventloop();
            if (this.subscription != null) {
                SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)new DuplicateSubscribeException((Object)this.subscription, subscriber));
            } else if (DefaultDnsClient.this.closed) {
                SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)new ClosedServiceDiscovererException(DefaultDnsClient.this + " has been closed!"));
            } else {
                this.subscription = this.newSubscription(subscriber);
                try {
                    subscriber.onSubscribe((PublisherSource.Subscription)this.subscription);
                }
                catch (Throwable cause) {
                    SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)cause);
                }
            }
        }

        @Nullable
        final List<ServiceDiscovererEvent<T>> close0() {
            DefaultDnsClient.this.assertInEventloop();
            if (this.subscription != null) {
                List events = this.subscription.cancelClearsSubscription ? null : this.subscription.generateInactiveEvent();
                this.subscription.closeAndTerminate0();
                return events;
            }
            return null;
        }

        abstract class AbstractDnsSubscription
        implements PublisherSource.Subscription {
            private final PublisherSource.Subscriber<? super Iterable<ServiceDiscovererEvent<T>>> subscriber;
            private final boolean cancelClearsSubscription;
            private long pendingRequests;
            private List<T> activeAddresses;
            private long resolveDoneNoScheduleTime;
            @Nullable
            private Cancellable cancellableForQuery;
            private long ttlNanos;

            AbstractDnsSubscription(boolean cancelClearsSubscription, PublisherSource.Subscriber<? super Iterable<ServiceDiscovererEvent<T>>> subscriber) {
                this.cancelClearsSubscription = cancelClearsSubscription;
                this.subscriber = subscriber;
                this.activeAddresses = Collections.emptyList();
                this.ttlNanos = -1L;
            }

            protected abstract Future<DnsAnswer<T>> doDnsQuery();

            protected abstract Comparator<T> comparator();

            public final void request(long n) {
                if (DefaultDnsClient.this.nettyIoExecutor.isCurrentThreadEventLoop()) {
                    this.request0(n);
                } else {
                    DefaultDnsClient.this.nettyIoExecutor.asExecutor().execute(() -> this.request0(n));
                }
            }

            public final void cancel() {
                if (DefaultDnsClient.this.nettyIoExecutor.isCurrentThreadEventLoop()) {
                    this.cancel0();
                } else {
                    DefaultDnsClient.this.nettyIoExecutor.asExecutor().execute(this::cancel0);
                }
            }

            private void request0(long n) {
                DefaultDnsClient.this.assertInEventloop();
                if (!SubscriberUtils.isRequestNValid((long)n)) {
                    this.handleTerminalError0(SubscriberUtils.newExceptionForInvalidRequestN((long)n));
                    return;
                }
                this.pendingRequests = FlowControlUtils.addWithOverflowProtection((long)this.pendingRequests, (long)n);
                if (this.cancellableForQuery == null) {
                    if (this.ttlNanos < 0L) {
                        this.doQuery0();
                    } else {
                        long durationNs = System.nanoTime() - this.resolveDoneNoScheduleTime;
                        if (durationNs > this.ttlNanos) {
                            this.doQuery0();
                        } else {
                            this.scheduleQuery0(this.ttlNanos - durationNs);
                        }
                    }
                } else if (this.cancellableForQuery == TERMINATE_ON_NEXT_REQUEST_N) {
                    assert (this.pendingRequests > 0L);
                    this.tryTerminateOnComplete();
                }
            }

            private void doQuery0() {
                DefaultDnsClient.this.assertInEventloop();
                if (DefaultDnsClient.this.closed) {
                    this.handleTerminalError0(new ClosedServiceDiscovererException(DefaultDnsClient.this + " has been closed!"));
                } else {
                    DnsServiceDiscovererObserver.DnsResolutionObserver resolutionObserver = this.newResolutionObserver();
                    LOGGER.trace("DnsClient {}, querying DNS for {}", (Object)DefaultDnsClient.this, (Object)AbstractDnsPublisher.this);
                    Future addressFuture = this.doDnsQuery();
                    this.cancellableForQuery = () -> addressFuture.cancel(true);
                    if (addressFuture.isDone()) {
                        this.handleResolveDone0(addressFuture, resolutionObserver);
                    } else {
                        addressFuture.addListener((GenericFutureListener)((FutureListener)f -> this.handleResolveDone0(f, resolutionObserver)));
                    }
                }
            }

            @Nullable
            private DnsServiceDiscovererObserver.DnsResolutionObserver newResolutionObserver() {
                DnsServiceDiscovererObserver.DnsDiscoveryObserver discoveryObserver = AbstractDnsPublisher.this.discoveryObserver;
                if (discoveryObserver == null) {
                    return null;
                }
                try {
                    return discoveryObserver.onNewResolution(AbstractDnsPublisher.this.name);
                }
                catch (Throwable unexpected) {
                    LOGGER.warn("Unexpected exception from {} while reporting new DNS resolution for: {}", new Object[]{DefaultDnsClient.this.observer, AbstractDnsPublisher.this.name, unexpected});
                    return null;
                }
            }

            private void cancel0() {
                DefaultDnsClient.this.assertInEventloop();
                if (this.cancellableForQuery != null) {
                    this.cancellableForQuery.cancel();
                }
                if (this.cancelClearsSubscription) {
                    this.clearState();
                }
            }

            private void clearState() {
                this.cancellableForQuery = TERMINATED;
                AbstractDnsPublisher.this.subscription = null;
            }

            private void closeAndTerminate0() {
                if (this.cancellableForQuery != null) {
                    this.cancellableForQuery.cancel();
                }
                this.tryTerminateOnComplete();
            }

            private void tryTerminateOnComplete() {
                boolean deliverTerminal;
                try {
                    deliverTerminal = this.clearAddressesAndPropagateRemovalEvents();
                }
                catch (Throwable cause) {
                    this.clearState();
                    SubscriberUtils.safeOnError(this.subscriber, (Throwable)cause);
                    return;
                }
                if (deliverTerminal) {
                    this.clearState();
                    SubscriberUtils.safeOnComplete(this.subscriber);
                } else {
                    this.cancellableForQuery = TERMINATE_ON_NEXT_REQUEST_N;
                }
            }

            private void scheduleQuery0(long nanos) {
                DefaultDnsClient.this.assertInEventloop();
                LOGGER.trace("DnsClient {}, scheduling DNS query for {} after {} nanos.", new Object[]{DefaultDnsClient.this, AbstractDnsPublisher.this, nanos});
                this.cancellableForQuery = DefaultDnsClient.this.nettyIoExecutor.asExecutor().schedule(this::doQuery0, nanos, TimeUnit.NANOSECONDS);
            }

            private void handleResolveDone0(Future<DnsAnswer<T>> addressFuture, @Nullable DnsServiceDiscovererObserver.DnsResolutionObserver resolutionObserver) {
                DefaultDnsClient.this.assertInEventloop();
                assert (this.pendingRequests > 0L);
                if (this.cancellableForQuery == TERMINATED) {
                    return;
                }
                if (this.cancellableForQuery == TERMINATE_ON_NEXT_REQUEST_N) {
                    this.tryTerminateOnComplete();
                    return;
                }
                Throwable cause = addressFuture.cause();
                if (cause != null) {
                    this.reportResolutionFailed(resolutionObserver, cause);
                    boolean deliverTerminal = true;
                    try {
                        deliverTerminal = !DefaultDnsClient.this.invalidateHostsOnDnsFailure.test(cause) || this.clearAddressesAndPropagateRemovalEvents();
                    }
                    catch (Throwable cause2) {
                        this.logUnexpectedException(cause2);
                    }
                    if (deliverTerminal) {
                        this.cancel0();
                        SubscriberUtils.safeOnError(this.subscriber, (Throwable)cause);
                    } else {
                        this.cancellableForQuery = TERMINATE_ON_NEXT_REQUEST_N;
                    }
                } else {
                    DnsAnswer dnsAnswer = (DnsAnswer)addressFuture.getNow();
                    List addresses = dnsAnswer.answer();
                    List events = ServiceDiscovererUtils.calculateDifference(this.activeAddresses, addresses, this.comparator(), resolutionObserver == null ? null : (nAvailable, nUnavailable) -> this.reportResolutionResult(resolutionObserver, dnsAnswer, nAvailable, nUnavailable));
                    this.ttlNanos = dnsAnswer.ttlNanos();
                    if (events != null) {
                        this.activeAddresses = addresses;
                        if (--this.pendingRequests > 0L) {
                            this.scheduleQuery0(this.ttlNanos);
                        } else {
                            this.resolveDoneNoScheduleTime = System.nanoTime();
                            this.cancellableForQuery = null;
                        }
                        try {
                            LOGGER.debug("DnsClient {}, sending events for address: {} (size {}) {}.", new Object[]{DefaultDnsClient.this, AbstractDnsPublisher.this, events.size(), events});
                            this.subscriber.onNext((Object)events);
                        }
                        catch (Throwable error) {
                            this.handleTerminalError0(error);
                        }
                    } else {
                        LOGGER.trace("DnsClient {}, resolution done but no changes for address: {} (size {}) {}.", new Object[]{DefaultDnsClient.this, AbstractDnsPublisher.this, this.activeAddresses.size(), this.activeAddresses});
                        this.scheduleQuery0(this.ttlNanos);
                    }
                }
            }

            private void reportResolutionFailed(@Nullable DnsServiceDiscovererObserver.DnsResolutionObserver resolutionObserver, Throwable cause) {
                if (resolutionObserver == null) {
                    return;
                }
                try {
                    resolutionObserver.resolutionFailed(cause);
                }
                catch (Throwable unexpected) {
                    unexpected.addSuppressed(cause);
                    LOGGER.warn("Unexpected exception from {} while reporting DNS resolution failure", (Object)resolutionObserver, (Object)unexpected);
                }
            }

            private void reportResolutionResult(DnsServiceDiscovererObserver.DnsResolutionObserver resolutionObserver, DnsAnswer<T> dnsAnswer, int nAvailable, int nUnavailable) {
                DefaultResolutionResult result = new DefaultResolutionResult(dnsAnswer.answer().size(), (int)TimeUnit.NANOSECONDS.toSeconds(dnsAnswer.ttlNanos()), nAvailable, nUnavailable);
                try {
                    resolutionObserver.resolutionCompleted(result);
                }
                catch (Throwable unexpected) {
                    LOGGER.warn("Unexpected exception from {} while reporting DNS resolution result {}", new Object[]{resolutionObserver, result, unexpected});
                }
            }

            private void handleTerminalError0(Throwable cause) {
                DefaultDnsClient.this.assertInEventloop();
                if (this.cancellableForQuery != TERMINATED) {
                    this.cancel0();
                    SubscriberUtils.safeOnError(this.subscriber, (Throwable)cause);
                }
            }

            private void logUnexpectedException(Throwable cause) {
                LOGGER.warn("Exception from subscriber {} while handling error in DNS subscription {}", new Object[]{this.subscriber, this, cause});
            }

            private boolean clearAddressesAndPropagateRemovalEvents() {
                DefaultDnsClient.this.assertInEventloop();
                if (this.activeAddresses.isEmpty()) {
                    return true;
                }
                if (this.pendingRequests > 0L) {
                    --this.pendingRequests;
                    this.subscriber.onNext(this.generateInactiveEvent());
                    return true;
                }
                return false;
            }

            private List<ServiceDiscovererEvent<T>> generateInactiveEvent() {
                ArrayList events = new ArrayList(this.activeAddresses.size());
                if (this.activeAddresses instanceof RandomAccess) {
                    for (int i = 0; i < this.activeAddresses.size(); ++i) {
                        events.add((ServiceDiscovererEvent)new DefaultServiceDiscovererEvent(this.activeAddresses.get(i), false));
                    }
                } else {
                    for (Object address : this.activeAddresses) {
                        events.add((ServiceDiscovererEvent)new DefaultServiceDiscovererEvent(address, false));
                    }
                }
                this.activeAddresses = Collections.emptyList();
                return events;
            }
        }
    }

    private static final class DnsAnswer<T> {
        private final List<T> answer;
        private final long ttlNanos;

        DnsAnswer(List<T> answer, long ttlNanos) {
            this.answer = answer;
            this.ttlNanos = ttlNanos;
        }

        List<T> answer() {
            return this.answer;
        }

        long ttlNanos() {
            return this.ttlNanos;
        }
    }

    private class ARecordPublisher
    extends AbstractDnsPublisher<InetAddress> {
        private final boolean cancelClearsSubscription;

        ARecordPublisher(boolean cancelClearsSubscription, @Nullable String inetHost, DnsServiceDiscovererObserver.DnsDiscoveryObserver discoveryObserver) {
            super(inetHost, discoveryObserver);
            this.cancelClearsSubscription = cancelClearsSubscription;
        }

        public String toString() {
            return "A* lookups for " + this.name;
        }

        @Override
        protected AbstractDnsPublisher.AbstractDnsSubscription newSubscription(PublisherSource.Subscriber<? super Iterable<ServiceDiscovererEvent<InetAddress>>> subscriber) {
            return new AbstractDnsPublisher.AbstractDnsSubscription(this.cancelClearsSubscription, subscriber){

                protected Future<DnsAnswer<InetAddress>> doDnsQuery() {
                    DefaultDnsClient.this.ttlCache.prepareForResolution(ARecordPublisher.this.name);
                    Promise dnsAnswerPromise = ImmediateEventExecutor.INSTANCE.newPromise();
                    DefaultDnsClient.this.resolver.resolveAll(ARecordPublisher.this.name).addListener(completedFuture -> {
                        Throwable cause = completedFuture.cause();
                        if (cause != null) {
                            dnsAnswerPromise.setFailure(cause);
                        } else {
                            DnsAnswer dnsAnswer;
                            try {
                                List addresses = (List)completedFuture.getNow();
                                dnsAnswer = new DnsAnswer(addresses, TimeUnit.SECONDS.toNanos(DefaultDnsClient.this.ttlCache.minTtl(ARecordPublisher.this.name)));
                            }
                            catch (Throwable cause2) {
                                dnsAnswerPromise.setFailure(cause2);
                                return;
                            }
                            dnsAnswerPromise.setSuccess(dnsAnswer);
                        }
                    });
                    return dnsAnswerPromise;
                }

                protected Comparator<InetAddress> comparator() {
                    return INET_ADDRESS_COMPARATOR;
                }
            };
        }
    }

    private final class SrvRecordPublisher
    extends AbstractDnsPublisher<HostAndPort> {
        private SrvRecordPublisher(@Nullable String serviceName, DnsServiceDiscovererObserver.DnsDiscoveryObserver discoveryObserver) {
            super(serviceName, discoveryObserver);
        }

        public String toString() {
            return "SRV lookups for " + this.name;
        }

        @Override
        protected AbstractDnsPublisher.AbstractDnsSubscription newSubscription(PublisherSource.Subscriber<? super Iterable<ServiceDiscovererEvent<HostAndPort>>> subscriber) {
            return new AbstractDnsPublisher.AbstractDnsSubscription(true, subscriber){

                protected Future<DnsAnswer<HostAndPort>> doDnsQuery() {
                    Promise promise = ImmediateEventExecutor.INSTANCE.newPromise();
                    DefaultDnsClient.this.resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion(SrvRecordPublisher.this.name, DnsRecordType.SRV)).addListener(completedFuture -> {
                        Throwable cause = completedFuture.cause();
                        if (cause != null) {
                            promise.setFailure(cause);
                        } else {
                            DnsAnswer dnsAnswer;
                            long minTTLSeconds = Long.MAX_VALUE;
                            List toRelease = null;
                            try {
                                List dnsRecords = (List)completedFuture.getNow();
                                toRelease = dnsRecords;
                                ArrayList<HostAndPort> hostAndPorts = new ArrayList<HostAndPort>(dnsRecords.size());
                                Iterator iterator = dnsRecords.iterator();
                                while (iterator.hasNext()) {
                                    DnsRecord dnsRecord = (DnsRecord)iterator.next();
                                    if (!DnsRecordType.SRV.equals((Object)dnsRecord.type()) || !(dnsRecord instanceof DnsRawRecord)) {
                                        throw new IllegalArgumentException("Unsupported DNS record type for SRV query: " + dnsRecord);
                                    }
                                    if (dnsRecord.timeToLive() < minTTLSeconds) {
                                        minTTLSeconds = dnsRecord.timeToLive();
                                    }
                                    ByteBuf content = ((DnsRawRecord)dnsRecord).content();
                                    content.skipBytes(4);
                                    int port = content.readUnsignedShort();
                                    hostAndPorts.add(HostAndPort.of((String)DefaultDnsRecordDecoder.decodeName((ByteBuf)content), (int)port));
                                }
                                dnsAnswer = new DnsAnswer(hostAndPorts, TimeUnit.SECONDS.toNanos(minTTLSeconds));
                            }
                            catch (Throwable cause2) {
                                promise.setFailure(cause2);
                                return;
                            }
                            finally {
                                if (toRelease != null) {
                                    for (DnsRecord dnsRecord : toRelease) {
                                        ReferenceCountUtil.release((Object)dnsRecord);
                                    }
                                }
                            }
                            promise.setSuccess(dnsAnswer);
                        }
                    });
                    return promise;
                }

                protected Comparator<HostAndPort> comparator() {
                    return HOST_AND_PORT_COMPARATOR;
                }
            };
        }
    }
}

