/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AfterFinallySingle;
import io.servicetalk.concurrent.api.AfterSubscriberSingle;
import io.servicetalk.concurrent.api.AmbSingles;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.BeforeFinallySingle;
import io.servicetalk.concurrent.api.BeforeSubscriberSingle;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.BiIntPredicate;
import io.servicetalk.concurrent.api.CallableSingle;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompletionStageToSingle;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.FailedSingle;
import io.servicetalk.concurrent.api.Function3;
import io.servicetalk.concurrent.api.Function4;
import io.servicetalk.concurrent.api.FutureToSingle;
import io.servicetalk.concurrent.api.LiftAsynchronousSingleOperator;
import io.servicetalk.concurrent.api.LiftSynchronousSingleOperator;
import io.servicetalk.concurrent.api.MapSingle;
import io.servicetalk.concurrent.api.NeverSingle;
import io.servicetalk.concurrent.api.OnErrorMapSingle;
import io.servicetalk.concurrent.api.OnErrorResumeSingle;
import io.servicetalk.concurrent.api.PublishAndSubscribeOnSingles;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RetrySingle;
import io.servicetalk.concurrent.api.RetryWhenSingle;
import io.servicetalk.concurrent.api.RunnableSingleTerminalSignalConsumer;
import io.servicetalk.concurrent.api.SimpleSingleSubscriber;
import io.servicetalk.concurrent.api.SingleAmbWith;
import io.servicetalk.concurrent.api.SingleConcatWithCompletable;
import io.servicetalk.concurrent.api.SingleConcatWithPublisher;
import io.servicetalk.concurrent.api.SingleDefer;
import io.servicetalk.concurrent.api.SingleDoOnUtils;
import io.servicetalk.concurrent.api.SingleFlatMapCompletable;
import io.servicetalk.concurrent.api.SingleFlatMapPublisher;
import io.servicetalk.concurrent.api.SingleFlatMapSingle;
import io.servicetalk.concurrent.api.SingleOperator;
import io.servicetalk.concurrent.api.SingleSubscribeShareContext;
import io.servicetalk.concurrent.api.SingleTerminalSignalConsumer;
import io.servicetalk.concurrent.api.SingleToCompletable;
import io.servicetalk.concurrent.api.SingleToCompletableFuture;
import io.servicetalk.concurrent.api.SingleToPublisher;
import io.servicetalk.concurrent.api.SingleZipper;
import io.servicetalk.concurrent.api.SourceToFuture;
import io.servicetalk.concurrent.api.SucceededSingle;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import io.servicetalk.concurrent.api.TerminalSingleTerminalSignalConsumer;
import io.servicetalk.concurrent.api.TimeoutSingle;
import io.servicetalk.concurrent.api.WhenCancellableSingle;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SignalOffloaders;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Single<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Single.class);
    private final io.servicetalk.concurrent.api.Executor executor;
    private final boolean shareContextOnSubscribe;

    protected Single() {
        this(Executors.immediate());
    }

    Single(io.servicetalk.concurrent.api.Executor executor) {
        this(executor, false);
    }

    Single(io.servicetalk.concurrent.api.Executor executor, boolean shareContextOnSubscribe) {
        this.executor = Objects.requireNonNull(executor);
        this.shareContextOnSubscribe = shareContextOnSubscribe;
    }

    public final <R> Single<R> map(Function<? super T, ? extends R> mapper) {
        return new MapSingle<T, R>(this, mapper, this.executor);
    }

    public final Single<T> onErrorReturn(Function<? super Throwable, ? extends T> itemSupplier) {
        return this.onErrorReturn((? super Throwable t) -> true, itemSupplier);
    }

    public final <E extends Throwable> Single<T> onErrorReturn(Class<E> type, Function<? super E, ? extends T> itemSupplier) {
        Function<? super E, ? extends T> rawSupplier = itemSupplier;
        return this.onErrorReturn(type::isInstance, rawSupplier);
    }

    public final Single<T> onErrorReturn(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends T> itemSupplier) {
        Objects.requireNonNull(itemSupplier);
        return this.onErrorResume(predicate, (? super Throwable t) -> Single.succeeded(itemSupplier.apply((Throwable)t)));
    }

    public final Single<T> onErrorMap(Function<? super Throwable, ? extends Throwable> mapper) {
        return this.onErrorMap((? super Throwable t) -> true, mapper);
    }

    public final <E extends Throwable> Single<T> onErrorMap(Class<E> type, Function<? super E, ? extends Throwable> mapper) {
        Function<? super E, ? extends Throwable> rawMapper = mapper;
        return this.onErrorMap(type::isInstance, rawMapper);
    }

    public final Single<T> onErrorMap(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Throwable> mapper) {
        return new OnErrorMapSingle(this, predicate, mapper, this.executor);
    }

    public final Single<T> onErrorResume(Function<? super Throwable, ? extends Single<? extends T>> nextFactory) {
        return this.onErrorResume((? super Throwable t) -> true, nextFactory);
    }

    public final <E extends Throwable> Single<T> onErrorResume(Class<E> type, Function<? super E, ? extends Single<? extends T>> nextFactory) {
        Function<? super E, ? extends Single<? extends T>> rawNextFactory = nextFactory;
        return this.onErrorResume(type::isInstance, rawNextFactory);
    }

    public final Single<T> onErrorResume(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Single<? extends T>> nextFactory) {
        return new OnErrorResumeSingle(this, predicate, nextFactory, this.executor);
    }

    @Deprecated
    public final Single<T> recoverWith(Function<? super Throwable, ? extends Single<? extends T>> nextFactory) {
        return this.onErrorResume(nextFactory);
    }

    public final <R> Single<R> flatMap(Function<? super T, ? extends Single<? extends R>> next) {
        return new SingleFlatMapSingle(this, next, this.executor);
    }

    public final Completable flatMapCompletable(Function<? super T, ? extends Completable> next) {
        return new SingleFlatMapCompletable<T>(this, next, this.executor);
    }

    public final <R> Publisher<R> flatMapPublisher(Function<? super T, ? extends Publisher<? extends R>> next) {
        return new SingleFlatMapPublisher(this, next, this.executor);
    }

    public final Single<T> whenOnSuccess(Consumer<? super T> onSuccess) {
        return this.beforeOnSuccess(onSuccess);
    }

    public final Single<T> whenOnError(Consumer<Throwable> onError) {
        return this.beforeOnError(onError);
    }

    public final Single<T> whenFinally(Runnable doFinally) {
        return this.beforeFinally(doFinally);
    }

    public final Single<T> whenFinally(TerminalSignalConsumer doFinally) {
        return this.beforeFinally(doFinally);
    }

    public final Single<T> whenFinally(SingleTerminalSignalConsumer<? super T> doFinally) {
        return this.beforeFinally(doFinally);
    }

    public final Single<T> whenCancel(Runnable onCancel) {
        return this.beforeCancel(onCancel);
    }

    @Deprecated
    public final Single<T> idleTimeout(long duration, TimeUnit unit) {
        return this.timeout(duration, unit, this.executor);
    }

    @Deprecated
    public final Single<T> idleTimeout(long duration, TimeUnit unit, Executor timeoutExecutor) {
        return new TimeoutSingle(this, duration, unit, timeoutExecutor);
    }

    @Deprecated
    public final Single<T> idleTimeout(Duration duration) {
        return this.timeout(duration, this.executor);
    }

    @Deprecated
    public final Single<T> idleTimeout(Duration duration, Executor timeoutExecutor) {
        return new TimeoutSingle(this, duration, timeoutExecutor);
    }

    public final Single<T> timeout(long duration, TimeUnit unit) {
        return this.timeout(duration, unit, this.executor);
    }

    public final Single<T> timeout(long duration, TimeUnit unit, Executor timeoutExecutor) {
        return new TimeoutSingle(this, duration, unit, timeoutExecutor);
    }

    public final Single<T> timeout(Duration duration) {
        return this.timeout(duration, this.executor);
    }

    public final Single<T> timeout(Duration duration, Executor timeoutExecutor) {
        return new TimeoutSingle(this, duration, timeoutExecutor);
    }

    public final Publisher<T> concat(Single<? extends T> next) {
        return this.toPublisher().concat(next);
    }

    public final Single<T> concat(Completable next) {
        return new SingleConcatWithCompletable(this, next, this.executor);
    }

    public final Publisher<T> concat(Publisher<? extends T> next) {
        return new SingleConcatWithPublisher<T>(this, next, this.executor);
    }

    public final <T2, R> Single<R> zipWith(Single<? extends T2> other, BiFunction<? super T, ? super T2, ? extends R> zipper) {
        return Single.zip(this, other, zipper);
    }

    public final Single<T> retry(BiIntPredicate<Throwable> shouldRetry) {
        return new RetrySingle(this, shouldRetry, this.executor);
    }

    public final Single<T> retryWhen(BiIntFunction<Throwable, ? extends Completable> retryWhen) {
        return new RetryWhenSingle(this, retryWhen, this.executor);
    }

    public final Publisher<T> repeat(IntPredicate shouldRepeat) {
        return this.toPublisher().repeat(shouldRepeat);
    }

    public final Publisher<T> repeatWhen(IntFunction<? extends Completable> repeatWhen) {
        return this.toPublisher().repeatWhen(repeatWhen);
    }

    public final Single<T> beforeOnSubscribe(Consumer<Cancellable> onSubscribe) {
        return this.beforeSubscriber(SingleDoOnUtils.doOnSubscribeSupplier(onSubscribe));
    }

    public final Single<T> beforeOnSuccess(Consumer<? super T> onSuccess) {
        return this.beforeSubscriber(SingleDoOnUtils.doOnSuccessSupplier(onSuccess));
    }

    public final Single<T> beforeOnError(Consumer<Throwable> onError) {
        return this.beforeSubscriber(SingleDoOnUtils.doOnErrorSupplier(onError));
    }

    public final Single<T> beforeCancel(Runnable onCancel) {
        return new WhenCancellableSingle(this, onCancel::run, true, this.executor);
    }

    public final Single<T> beforeFinally(Runnable doFinally) {
        return this.beforeFinally(new RunnableSingleTerminalSignalConsumer(doFinally));
    }

    public final Single<T> beforeFinally(TerminalSignalConsumer doFinally) {
        return new BeforeFinallySingle(this, new TerminalSingleTerminalSignalConsumer(doFinally), this.executor);
    }

    public final Single<T> beforeFinally(SingleTerminalSignalConsumer<? super T> doFinally) {
        return new BeforeFinallySingle<T>(this, doFinally, this.executor);
    }

    public final Single<T> beforeSubscriber(Supplier<? extends SingleSource.Subscriber<? super T>> subscriberSupplier) {
        return new BeforeSubscriberSingle(this, subscriberSupplier, this.executor);
    }

    public final Single<T> afterOnSubscribe(Consumer<Cancellable> onSubscribe) {
        return this.afterSubscriber(SingleDoOnUtils.doOnSubscribeSupplier(onSubscribe));
    }

    public final Single<T> whenOnSubscribe(Consumer<Cancellable> onSubscribe) {
        return this.beforeOnSubscribe(onSubscribe);
    }

    public final Single<T> afterOnSuccess(Consumer<? super T> onSuccess) {
        return this.afterSubscriber(SingleDoOnUtils.doOnSuccessSupplier(onSuccess));
    }

    public final Single<T> afterOnError(Consumer<Throwable> onError) {
        return this.afterSubscriber(SingleDoOnUtils.doOnErrorSupplier(onError));
    }

    public final Single<T> afterCancel(Runnable onCancel) {
        return new WhenCancellableSingle(this, onCancel::run, false, this.executor);
    }

    public final Single<T> afterFinally(Runnable doFinally) {
        return this.afterFinally(new RunnableSingleTerminalSignalConsumer(doFinally));
    }

    public final Single<T> afterFinally(TerminalSignalConsumer doFinally) {
        return new AfterFinallySingle(this, new TerminalSingleTerminalSignalConsumer(doFinally), this.executor);
    }

    public final Single<T> afterFinally(SingleTerminalSignalConsumer<? super T> doFinally) {
        return new AfterFinallySingle<T>(this, doFinally, this.executor);
    }

    public final Single<T> afterSubscriber(Supplier<? extends SingleSource.Subscriber<? super T>> subscriberSupplier) {
        return new AfterSubscriberSingle(this, subscriberSupplier, this.executor);
    }

    public final Single<T> whenSubscriber(Supplier<? extends SingleSource.Subscriber<? super T>> subscriberSupplier) {
        return this.beforeSubscriber(subscriberSupplier);
    }

    public final Single<T> publishOn(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnSingles.publishOn(this, executor);
    }

    public final Single<T> publishOnOverride(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnSingles.publishOnOverride(this, executor);
    }

    public final Single<T> subscribeOn(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnSingles.subscribeOn(this, executor);
    }

    public final Single<T> subscribeOnOverride(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnSingles.subscribeOnOverride(this, executor);
    }

    public final Single<T> publishAndSubscribeOn(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnSingles.publishAndSubscribeOn(this, executor);
    }

    public final Single<T> publishAndSubscribeOnOverride(io.servicetalk.concurrent.api.Executor executor) {
        return PublishAndSubscribeOnSingles.publishAndSubscribeOnOverride(this, executor);
    }

    public final Single<T> subscribeShareContext() {
        return new SingleSubscribeShareContext(this);
    }

    public final <R> Single<R> liftSync(SingleOperator<? super T, ? extends R> operator) {
        return new LiftSynchronousSingleOperator<T, R>(this, operator, this.executor);
    }

    public final <R> Single<R> liftAsync(SingleOperator<? super T, ? extends R> operator) {
        return new LiftAsynchronousSingleOperator<T, R>(this, operator, this.executor);
    }

    public final Single<T> ambWith(Single<T> other) {
        return new SingleAmbWith<T>(this.executor, this, other);
    }

    public final Publisher<T> toPublisher() {
        return new SingleToPublisher(this, this.executor);
    }

    public final Completable toCompletable() {
        return new SingleToCompletable(this, this.executor);
    }

    public final Completable ignoreElement() {
        return this.toCompletable();
    }

    public final CompletionStage<T> toCompletionStage() {
        return SingleToCompletableFuture.createAndSubscribe(this);
    }

    public final Future<T> toFuture() {
        return SourceToFuture.SingleToFuture.createAndSubscribe(this);
    }

    protected final void subscribeInternal(SingleSource.Subscriber<? super T> subscriber) {
        this.subscribeAndReturnContext(subscriber, AsyncContext.provider());
    }

    public final Cancellable subscribe(Consumer<? super T> resultConsumer) {
        SimpleSingleSubscriber<? super T> subscriber = new SimpleSingleSubscriber<T>(resultConsumer);
        this.subscribeInternal(subscriber);
        return subscriber;
    }

    protected abstract void handleSubscribe(SingleSource.Subscriber<? super T> var1);

    public static <T> Single<T> succeeded(@Nullable T value) {
        return new SucceededSingle<T>(value);
    }

    public static <T> Single<T> fromCallable(Callable<T> callable) {
        return new CallableSingle<T>(callable);
    }

    public static <T> Single<T> fromSupplier(Supplier<T> supplier) {
        return Single.fromCallable(supplier::get);
    }

    public static <T> Single<T> failed(Throwable cause) {
        return new FailedSingle(cause);
    }

    public static <T> Single<T> never() {
        return NeverSingle.neverSingle();
    }

    public static <T> Single<T> defer(Supplier<? extends Single<? extends T>> singleSupplier) {
        return new SingleDefer(singleSupplier);
    }

    public static <T> Single<T> fromFuture(Future<? extends T> future) {
        return new FutureToSingle<T>(future);
    }

    public static <T> Single<Collection<T>> collectUnordered(Iterable<? extends Single<? extends T>> singles) {
        return Publisher.fromIterable(singles).flatMapMergeSingle(Function.identity()).collect(ArrayList::new, (ts, t) -> {
            ts.add(t);
            return ts;
        });
    }

    @SafeVarargs
    public static <T> Single<Collection<T>> collectUnordered(Single<? extends T> ... singles) {
        return Publisher.from(singles).flatMapMergeSingle(Function.identity()).collect(() -> new ArrayList(singles.length), (ts, t) -> {
            ts.add(t);
            return ts;
        });
    }

    public static <T> Single<Collection<T>> collectUnordered(Iterable<? extends Single<? extends T>> singles, int maxConcurrency) {
        return Publisher.fromIterable(singles).flatMapMergeSingle(Function.identity(), maxConcurrency).collect(ArrayList::new, (ts, t) -> {
            ts.add(t);
            return ts;
        });
    }

    @SafeVarargs
    public static <T> Single<Collection<T>> collectUnordered(int maxConcurrency, Single<? extends T> ... singles) {
        return Publisher.from(singles).flatMapMergeSingle(Function.identity(), maxConcurrency).collect(() -> new ArrayList(singles.length), (ts, t) -> {
            ts.add(t);
            return ts;
        });
    }

    public static <T> Single<Collection<T>> collectUnorderedDelayError(Iterable<? extends Single<? extends T>> singles) {
        return Publisher.fromIterable(singles).flatMapMergeSingleDelayError(Function.identity()).collect(ArrayList::new, (ts, t) -> {
            ts.add(t);
            return ts;
        });
    }

    @SafeVarargs
    public static <T> Single<Collection<T>> collectUnorderedDelayError(Single<? extends T> ... singles) {
        return Publisher.from(singles).flatMapMergeSingleDelayError(Function.identity()).collect(() -> new ArrayList(singles.length), (ts, t) -> {
            ts.add(t);
            return ts;
        });
    }

    public static <T> Single<Collection<T>> collectUnorderedDelayError(Iterable<? extends Single<? extends T>> singles, int maxConcurrency) {
        return Publisher.fromIterable(singles).flatMapMergeSingleDelayError(Function.identity(), maxConcurrency).collect(ArrayList::new, (ts, t) -> {
            ts.add(t);
            return ts;
        });
    }

    @SafeVarargs
    public static <T> Single<Collection<T>> collectUnorderedDelayError(int maxConcurrency, Single<? extends T> ... singles) {
        return Publisher.from(singles).flatMapMergeSingleDelayError(Function.identity(), maxConcurrency).collect(() -> new ArrayList(singles.length), (ts, t) -> {
            ts.add(t);
            return ts;
        });
    }

    public static <T> Single<T> fromStage(CompletionStage<? extends T> stage) {
        return new CompletionStageToSingle<T>(stage);
    }

    @SafeVarargs
    public static <T> Single<T> amb(Single<? extends T> ... singles) {
        return new AmbSingles<T>(singles);
    }

    public static <T> Single<T> amb(Iterable<Single<? extends T>> singles) {
        return new AmbSingles<T>(singles);
    }

    @SafeVarargs
    public static <T> Single<T> anyOf(Single<? extends T> ... singles) {
        return Single.amb(singles);
    }

    public static <T> Single<T> anyOf(Iterable<Single<? extends T>> singles) {
        return Single.amb(singles);
    }

    public static <T1, T2, R> Single<R> zip(Single<? extends T1> s1, Single<? extends T2> s2, BiFunction<? super T1, ? super T2, ? extends R> zipper) {
        return SingleZipper.zip(s1, s2, zipper);
    }

    public static <T1, T2, T3, R> Single<R> zip(Single<? extends T1> s1, Single<? extends T2> s2, Single<? extends T3> s3, Function3<? super T1, ? super T2, ? super T3, ? extends R> zipper) {
        return SingleZipper.zip(s1, s2, s3, zipper);
    }

    public static <T1, T2, T3, T4, R> Single<R> zip(Single<? extends T1> s1, Single<? extends T2> s2, Single<? extends T3> s3, Single<? extends T4> s4, Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipper) {
        return SingleZipper.zip(s1, s2, s3, s4, zipper);
    }

    public static <R> Single<R> zip(Function<? super Object[], ? extends R> zipper, Single<?> ... singles) {
        return SingleZipper.zip(zipper, singles);
    }

    final AsyncContextMap subscribeAndReturnContext(SingleSource.Subscriber<? super T> subscriber, AsyncContextProvider provider) {
        AsyncContextMap contextMap = this.shareContextOnSubscribe ? provider.contextMap() : provider.contextMap().copy();
        this.subscribeWithContext(subscriber, provider, contextMap);
        return contextMap;
    }

    final void subscribeWithSharedContext(SingleSource.Subscriber<? super T> subscriber, AsyncContextProvider provider) {
        this.subscribeWithContext(subscriber, provider, provider.contextMap());
    }

    final void delegateSubscribe(SingleSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.handleSubscribe(subscriber, signalOffloader, contextMap, contextProvider);
    }

    private void subscribeWithContext(SingleSource.Subscriber<? super T> subscriber, AsyncContextProvider provider, AsyncContextMap contextMap) {
        SingleSource.Subscriber offloadedSubscriber;
        SignalOffloader signalOffloader;
        Objects.requireNonNull(subscriber);
        try {
            signalOffloader = SignalOffloaders.newOffloaderFor((Executor)this.executor);
            offloadedSubscriber = signalOffloader.offloadCancellable(provider.wrapCancellable(subscriber, contextMap));
        }
        catch (Throwable t) {
            SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)t);
            return;
        }
        signalOffloader.offloadSubscribe(offloadedSubscriber, provider.wrapConsumer(s -> this.handleSubscribe((SingleSource.Subscriber<? super T>)s, signalOffloader, contextMap, provider), contextMap));
    }

    void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        try {
            SingleSource.Subscriber offloaded = signalOffloader.offloadSubscriber(contextProvider.wrapSingleSubscriber(subscriber, contextMap));
            this.handleSubscribe(offloaded);
        }
        catch (Throwable t) {
            LOGGER.warn("Unexpected exception from subscribe(), assuming no interaction with the Subscriber.", t);
            SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)t);
        }
    }

    final io.servicetalk.concurrent.api.Executor executor() {
        return this.executor;
    }

    static {
        AsyncContext.autoEnable();
    }
}

