/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.internal.EmptySubscriptions;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class SequentialSubscription
implements PublisherSource.Subscription,
Cancellable {
    private static final long SWITCHING = -1L;
    private static final long REQUESTED = -2L;
    private static final long CANCELLED = -3L;
    private static final AtomicLongFieldUpdater<SequentialSubscription> requestedUpdater = AtomicLongFieldUpdater.newUpdater(SequentialSubscription.class, "requested");
    private static final AtomicLongFieldUpdater<SequentialSubscription> sourceRequestedUpdater = AtomicLongFieldUpdater.newUpdater(SequentialSubscription.class, "sourceRequested");
    private PublisherSource.Subscription subscription;
    private long sourceEmitted;
    private volatile long requested;
    private volatile long sourceRequested;

    SequentialSubscription() {
        this(EmptySubscriptions.EMPTY_SUBSCRIPTION_NO_THROW);
    }

    SequentialSubscription(PublisherSource.Subscription delegate) {
        this.subscription = Objects.requireNonNull(delegate);
    }

    public void request(long n) {
        long currSourceRequested;
        long currRequested;
        if (SubscriberUtils.isRequestNValid((long)n)) {
            currRequested = requestedUpdater.accumulateAndGet(this, n, FlowControlUtils::addWithOverflowProtectionIfNotNegative);
        } else {
            this.requested = currRequested = SequentialSubscription.sanitizeInvalidRequestN(n);
        }
        while ((currSourceRequested = this.sourceRequested) != -3L) {
            if (currSourceRequested < 0L) {
                assert (currSourceRequested == -1L || currSourceRequested == -2L);
                if (!sourceRequestedUpdater.compareAndSet(this, currSourceRequested, -2L)) continue;
                break;
            }
            PublisherSource.Subscription currSubscription = this.subscription;
            if (SubscriberUtils.isRequestNValid((long)currRequested)) {
                long delta = currRequested - currSourceRequested;
                if (!sourceRequestedUpdater.compareAndSet(this, currSourceRequested, currSourceRequested + delta)) continue;
                if (delta == 0L) break;
                currSubscription.request(delta);
                break;
            }
            if (!sourceRequestedUpdater.compareAndSet(this, currSourceRequested, -3L)) continue;
            currSubscription.request(currRequested);
            break;
        }
    }

    public void cancel() {
        PublisherSource.Subscription currSubscription = this.subscription;
        long currSourceRequested = sourceRequestedUpdater.getAndSet(this, -3L);
        if (currSourceRequested >= 0L) {
            currSubscription.cancel();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void switchTo(PublisherSource.Subscription next) {
        Objects.requireNonNull(next);
        long effectiveSourceRequested = this.sourceEmitted;
        while (true) {
            long currRequested;
            long currSourceRequested = this.sourceRequested;
            assert (currSourceRequested != -1L);
            if (currSourceRequested == -3L) {
                currRequested = this.requested;
                if (currRequested >= 0L) {
                    next.cancel();
                    return;
                }
                next.request(currRequested);
                return;
            }
            if (!sourceRequestedUpdater.compareAndSet(this, currSourceRequested, -1L)) continue;
            assert (currSourceRequested >= 0L || currSourceRequested == -2L);
            currRequested = this.requested;
            if (currRequested < 0L) {
                this.sourceRequested = -3L;
                next.request(currRequested);
                return;
            }
            long delta = currRequested - effectiveSourceRequested;
            assert (delta >= 0L);
            if (delta != 0L) {
                effectiveSourceRequested = currRequested;
                next.request(delta);
            }
            this.subscription = next;
            if (sourceRequestedUpdater.compareAndSet(this, -1L, currRequested)) return;
        }
    }

    void itemReceived() {
        ++this.sourceEmitted;
    }

    private static long sanitizeInvalidRequestN(long n) {
        return n == 0L ? Long.MIN_VALUE : n;
    }
}

