/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.ThreadInterruptingCancellable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunnableCompletable
extends AbstractSynchronousCompletable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnableCompletable.class);
    private final Runnable runnable;

    RunnableCompletable(Runnable runnable) {
        this.runnable = Objects.requireNonNull(runnable);
    }

    @Override
    void doSubscribe(CompletableSource.Subscriber subscriber) {
        ThreadInterruptingCancellable cancellable = new ThreadInterruptingCancellable(Thread.currentThread());
        try {
            subscriber.onSubscribe((Cancellable)cancellable);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe((CompletableSource.Subscriber)subscriber, (Throwable)t);
            return;
        }
        try {
            this.runnable.run();
            try {
                cancellable.setDone();
                subscriber.onComplete();
            }
            catch (Throwable t) {
                LOGGER.info("Ignoring exception from onComplete of Subscriber {}.", (Object)subscriber, (Object)t);
            }
        }
        catch (Throwable t) {
            cancellable.setDone(t);
            subscriber.onError(t);
        }
    }
}

