/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.AutoClosableUtils;
import io.servicetalk.concurrent.internal.ConcurrentUtils;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.TerminalNotification;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Function;
import javax.annotation.Nullable;

final class PublisherConcatMapIterable<T, U>
extends AbstractSynchronousPublisherOperator<T, U> {
    private static final long CANCEL_PENDING = -1L;
    private static final long CANCELLED = Long.MIN_VALUE;
    private final Function<? super T, ? extends Iterable<? extends U>> mapper;

    PublisherConcatMapIterable(Publisher<T> original, Function<? super T, ? extends Iterable<? extends U>> mapper, Executor executor) {
        super(original, executor);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super U> subscriber) {
        return new FlatMapIterableSubscriber<T, U>(this.mapper, subscriber);
    }

    private static final class FlatMapIterableSubscriber<T, U>
    implements PublisherSource.Subscriber<T>,
    PublisherSource.Subscription {
        private static final AtomicLongFieldUpdater<FlatMapIterableSubscriber> requestNUpdater = AtomicLongFieldUpdater.newUpdater(FlatMapIterableSubscriber.class, "requestN");
        private static final AtomicIntegerFieldUpdater<FlatMapIterableSubscriber> emittingUpdater = AtomicIntegerFieldUpdater.newUpdater(FlatMapIterableSubscriber.class, "emitting");
        private final Function<? super T, ? extends Iterable<? extends U>> mapper;
        private final PublisherSource.Subscriber<? super U> target;
        @Nullable
        private PublisherSource.Subscription sourceSubscription;
        @Nullable
        private TerminalNotification terminalNotification;
        private Iterator<? extends U> currentIterator = Collections.emptyIterator();
        private volatile long requestN;
        private volatile int emitting;

        FlatMapIterableSubscriber(Function<? super T, ? extends Iterable<? extends U>> mapper, PublisherSource.Subscriber<? super U> target) {
            this.target = target;
            this.mapper = mapper;
        }

        public void onSubscribe(PublisherSource.Subscription s) {
            if (SubscriberUtils.checkDuplicateSubscription((PublisherSource.Subscription)this.sourceSubscription, (PublisherSource.Subscription)s)) {
                this.sourceSubscription = s;
                this.target.onSubscribe((PublisherSource.Subscription)this);
            }
        }

        public void onNext(T u) {
            this.currentIterator = Objects.requireNonNull(this.mapper.apply(u).iterator());
            this.tryDrainIterator(ErrorHandlingStrategyInDrain.Throw);
        }

        public void onError(Throwable t) {
            this.terminalNotification = TerminalNotification.error((Throwable)t);
            this.tryDrainIterator(ErrorHandlingStrategyInDrain.Propagate);
        }

        public void onComplete() {
            this.terminalNotification = TerminalNotification.complete();
            this.tryDrainIterator(ErrorHandlingStrategyInDrain.Propagate);
        }

        public void request(long n) {
            assert (this.sourceSubscription != null);
            if (!SubscriberUtils.isRequestNValid((long)n)) {
                this.sourceSubscription.request(n);
            } else {
                requestNUpdater.accumulateAndGet(this, n, FlowControlUtils::addWithOverflowProtectionIfNotNegative);
                this.tryDrainIterator(ErrorHandlingStrategyInDrain.PropagateAndCancel);
            }
        }

        public void cancel() {
            long currRequestN;
            while ((currRequestN = this.requestN) >= 0L) {
                if (!requestNUpdater.compareAndSet(this, currRequestN, -1L)) continue;
                if (!ConcurrentUtils.tryAcquireLock(emittingUpdater, (Object)this)) break;
                try {
                    this.requestN = Long.MIN_VALUE;
                    this.doCancel();
                    break;
                }
                finally {
                    if (!ConcurrentUtils.releaseLock(emittingUpdater, (Object)this)) {
                        this.tryDrainIterator(ErrorHandlingStrategyInDrain.Propagate);
                    }
                }
            }
        }

        private void doCancel() {
            assert (this.sourceSubscription != null);
            Iterator<? extends U> currentIterator = this.currentIterator;
            this.currentIterator = EmptyIterator.instance();
            try {
                FlatMapIterableSubscriber.tryClose(currentIterator);
            }
            finally {
                this.sourceSubscription.cancel();
            }
        }

        private static <U> void tryClose(Iterator<? extends U> currentIterator) {
            if (currentIterator instanceof AutoCloseable) {
                AutoClosableUtils.closeAndReThrowUnchecked((AutoCloseable)((AutoCloseable)((Object)currentIterator)));
            }
        }

        /*
         * Exception decompiling
         */
        private void tryDrainIterator(ErrorHandlingStrategyInDrain errorHandlingStrategyInDrain) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static final class EmptyIterator<U>
        implements Iterator<U> {
            private static final EmptyIterator INSTANCE = new EmptyIterator();

            private EmptyIterator() {
            }

            static <T> EmptyIterator<T> instance() {
                return INSTANCE;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public U next() {
                throw new NoSuchElementException();
            }
        }

        private static enum ErrorHandlingStrategyInDrain {
            PropagateAndCancel,
            Propagate,
            Throw;

        }
    }
}

