/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisher;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import javax.annotation.Nullable;

final class From3Publisher<T>
extends AbstractSynchronousPublisher<T> {
    @Nullable
    private final T v1;
    @Nullable
    private final T v2;
    @Nullable
    private final T v3;

    From3Publisher(@Nullable T v1, @Nullable T v2, @Nullable T v3) {
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
    }

    @Override
    void doSubscribe(PublisherSource.Subscriber<? super T> subscriber) {
        try {
            subscriber.onSubscribe((PublisherSource.Subscription)new ThreeValueSubscription(subscriber));
        }
        catch (Throwable cause) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)cause);
        }
    }

    private final class ThreeValueSubscription
    implements PublisherSource.Subscription {
        private static final byte INIT = 0;
        private static final byte DELIVERED_V1 = 1;
        private static final byte DELIVERED_V2 = 2;
        private static final byte CANCELLED = 3;
        private static final byte TERMINATED = 4;
        private byte state;
        private final PublisherSource.Subscriber<? super T> subscriber;

        private ThreeValueSubscription(PublisherSource.Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        public void cancel() {
            if (this.state != 4) {
                this.state = (byte)3;
            }
        }

        public void request(long n) {
            if (this.state == 4) {
                return;
            }
            if (!SubscriberUtils.isRequestNValid((long)n)) {
                this.state = (byte)4;
                this.subscriber.onError((Throwable)SubscriberUtils.newExceptionForInvalidRequestN((long)n));
                return;
            }
            if (this.state == 0) {
                this.state = 1;
                try {
                    this.subscriber.onNext(From3Publisher.this.v1);
                }
                catch (Throwable cause) {
                    this.state = (byte)4;
                    this.subscriber.onError(cause);
                    return;
                }
                if (n > 2L) {
                    this.deliverV2V3();
                } else if (n == 2L) {
                    this.deliverV2();
                }
            } else if (this.state == 1) {
                if (n > 1L) {
                    this.deliverV2V3();
                } else {
                    this.deliverV2();
                }
            } else if (this.state == 2) {
                this.state = (byte)4;
                try {
                    this.subscriber.onNext(From3Publisher.this.v3);
                }
                catch (Throwable cause) {
                    this.subscriber.onError(cause);
                    return;
                }
                this.subscriber.onComplete();
            }
        }

        private void deliverV2() {
            this.state = (byte)2;
            try {
                this.subscriber.onNext(From3Publisher.this.v2);
            }
            catch (Throwable cause) {
                this.state = (byte)4;
                this.subscriber.onError(cause);
            }
        }

        private void deliverV2V3() {
            this.state = (byte)4;
            try {
                this.subscriber.onNext(From3Publisher.this.v2);
                this.subscriber.onNext(From3Publisher.this.v3);
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return;
            }
            this.subscriber.onComplete();
        }
    }
}

