/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisher;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import javax.annotation.Nullable;

final class From2Publisher<T>
extends AbstractSynchronousPublisher<T> {
    @Nullable
    private final T v1;
    @Nullable
    private final T v2;

    From2Publisher(@Nullable T v1, @Nullable T v2) {
        this.v1 = v1;
        this.v2 = v2;
    }

    @Override
    void doSubscribe(PublisherSource.Subscriber<? super T> subscriber) {
        try {
            subscriber.onSubscribe((PublisherSource.Subscription)new TwoValueSubscription(subscriber));
        }
        catch (Throwable cause) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)cause);
        }
    }

    private final class TwoValueSubscription
    implements PublisherSource.Subscription {
        private static final byte INIT = 0;
        private static final byte DELIVERED_V1 = 1;
        private static final byte CANCELLED = 2;
        private static final byte TERMINATED = 3;
        private byte state;
        private final PublisherSource.Subscriber<? super T> subscriber;

        private TwoValueSubscription(PublisherSource.Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        public void cancel() {
            if (this.state != 3) {
                this.state = (byte)2;
            }
        }

        public void request(long n) {
            if (this.state == 3) {
                return;
            }
            if (!SubscriberUtils.isRequestNValid((long)n)) {
                this.state = (byte)3;
                this.subscriber.onError((Throwable)SubscriberUtils.newExceptionForInvalidRequestN((long)n));
                return;
            }
            if (this.state == 0) {
                this.state = 1;
                try {
                    this.subscriber.onNext(From2Publisher.this.v1);
                }
                catch (Throwable cause) {
                    this.state = (byte)3;
                    this.subscriber.onError(cause);
                    return;
                }
                if (n > 1L) {
                    this.deliverV2();
                }
            } else if (this.state == 1) {
                this.deliverV2();
            }
        }

        private void deliverV2() {
            this.state = (byte)3;
            try {
                this.subscriber.onNext(From2Publisher.this.v2);
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return;
            }
            this.subscriber.onComplete();
        }
    }
}

