/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.ContextPreservingSubscription;
import java.util.Objects;

final class ContextPreservingSubscriptionSubscriber<T>
implements PublisherSource.Subscriber<T> {
    final AsyncContextMap saved;
    final PublisherSource.Subscriber<T> subscriber;

    ContextPreservingSubscriptionSubscriber(PublisherSource.Subscriber<T> subscriber, AsyncContextMap current) {
        this.subscriber = Objects.requireNonNull(subscriber);
        this.saved = Objects.requireNonNull(current);
    }

    public void onSubscribe(PublisherSource.Subscription subscription) {
        this.subscriber.onSubscribe(ContextPreservingSubscription.wrap(subscription, this.saved));
    }

    public void onNext(T t) {
        this.subscriber.onNext(t);
    }

    public void onError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    public void onComplete() {
        this.subscriber.onComplete();
    }

    public String toString() {
        return ContextPreservingSubscriptionSubscriber.class.getSimpleName() + "(" + this.subscriber + ')';
    }
}

