/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextMapUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;

final class ConcurrentAsyncContextMap
implements AsyncContextMap {
    private final Map<AsyncContextMap.Key<?>, Object> theMap;

    ConcurrentAsyncContextMap() {
        this.theMap = new ConcurrentHashMap(4);
    }

    private ConcurrentAsyncContextMap(ConcurrentAsyncContextMap rhs) {
        this.theMap = new ConcurrentHashMap(rhs.theMap);
    }

    @Override
    @Nullable
    public <T> T get(AsyncContextMap.Key<T> key) {
        return (T)this.theMap.get(key);
    }

    @Override
    public boolean containsKey(AsyncContextMap.Key<?> key) {
        return this.theMap.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.theMap.isEmpty();
    }

    @Override
    public int size() {
        return this.theMap.size();
    }

    @Override
    @Nullable
    public <T> T put(AsyncContextMap.Key<T> key, @Nullable T value) {
        assert (value != null);
        return (T)this.theMap.put(key, value);
    }

    @Override
    public void putAll(Map<AsyncContextMap.Key<?>, Object> map) {
        this.theMap.putAll(map);
    }

    @Override
    public <T> T remove(AsyncContextMap.Key<T> key) {
        return (T)this.theMap.remove(key);
    }

    @Override
    public boolean removeAll(Iterable<AsyncContextMap.Key<?>> entries) {
        boolean removed = false;
        for (AsyncContextMap.Key<?> k : entries) {
            removed |= this.theMap.remove(k) != null;
        }
        return removed;
    }

    @Override
    public void clear() {
        this.theMap.clear();
    }

    @Override
    @Nullable
    public AsyncContextMap.Key<?> forEach(BiPredicate<AsyncContextMap.Key<?>, Object> consumer) {
        for (Map.Entry<AsyncContextMap.Key<?>, Object> entry : this.theMap.entrySet()) {
            if (consumer.test(entry.getKey(), entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public AsyncContextMap copy() {
        return new ConcurrentAsyncContextMap(this);
    }

    public String toString() {
        return AsyncContextMapUtils.contextMapToString(this);
    }
}

