/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.CancellableStack;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

abstract class CompletableMergeSubscriber
implements CompletableSource.Subscriber {
    private static final AtomicReferenceFieldUpdater<CompletableMergeSubscriber, Object> terminalNotificationUpdater = AtomicReferenceFieldUpdater.newUpdater(CompletableMergeSubscriber.class, Object.class, "terminalNotification");
    private static final Object ON_COMPLETE = new Object();
    private static final Object DELIVERED_DELAYED_ERROR = new Object();
    @Nullable
    private volatile Object terminalNotification;
    private final CompletableSource.Subscriber subscriber;
    private final CancellableStack dynamicCancellable;
    private final boolean delayError;

    CompletableMergeSubscriber(CompletableSource.Subscriber subscriber, boolean delayError) {
        this.subscriber = subscriber;
        this.delayError = delayError;
        this.dynamicCancellable = new CancellableStack();
        subscriber.onSubscribe((Cancellable)this.dynamicCancellable);
    }

    public final void onSubscribe(Cancellable cancellable) {
        this.dynamicCancellable.add(cancellable);
    }

    public final void onComplete() {
        if (this.onTerminate()) {
            this.tryToCompleteSubscriber();
        }
    }

    public final void onError(Throwable t) {
        block3: {
            Object terminalNotification;
            while ((terminalNotification = this.terminalNotification) == null) {
                if (!terminalNotificationUpdater.compareAndSet(this, null, t)) {
                    if (this.delayError) continue;
                    return;
                }
                break block3;
            }
            Throwable tmpT = (Throwable)terminalNotification;
            tmpT.addSuppressed(t);
            t = tmpT;
        }
        if (!this.delayError || this.onTerminate() && t == terminalNotificationUpdater.getAndSet(this, DELIVERED_DELAYED_ERROR)) {
            this.onError0(t);
        }
    }

    final void tryToCompleteSubscriber() {
        Object maybeThrowable;
        if (terminalNotificationUpdater.compareAndSet(this, null, ON_COMPLETE)) {
            this.subscriber.onComplete();
        } else if (this.delayError && (maybeThrowable = terminalNotificationUpdater.getAndSet(this, DELIVERED_DELAYED_ERROR)) instanceof Throwable) {
            this.onError0((Throwable)maybeThrowable);
        }
    }

    private void onError0(Throwable t) {
        if (!this.delayError) {
            this.dynamicCancellable.cancel();
        }
        this.subscriber.onError(t);
    }

    abstract boolean onTerminate();
}

