/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AbstractProcessorBuffer;
import io.servicetalk.concurrent.api.ProcessorSignalsConsumer;
import io.servicetalk.concurrent.api.PublisherProcessorSignalsHolder;
import io.servicetalk.concurrent.api.SubscriberApiUtils;
import io.servicetalk.concurrent.internal.QueueFullException;
import io.servicetalk.concurrent.internal.TerminalNotification;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

abstract class AbstractPublisherProcessorSignalsHolder<T, Q extends Queue<Object>>
extends AbstractProcessorBuffer
implements PublisherProcessorSignalsHolder<T> {
    private static final AtomicIntegerFieldUpdater<AbstractPublisherProcessorSignalsHolder> bufferedUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractPublisherProcessorSignalsHolder.class, "buffered");
    private final int maxBuffer;
    private final Q signals;
    private volatile int buffered;

    AbstractPublisherProcessorSignalsHolder(int maxBuffer, Q signals) {
        if (maxBuffer <= 0) {
            throw new IllegalArgumentException("maxBuffer: " + maxBuffer + " (expected > 0)");
        }
        this.maxBuffer = maxBuffer;
        this.signals = (Queue)Objects.requireNonNull(signals);
    }

    @Override
    public void add(@Nullable T item) {
        if (bufferedUpdater.getAndAccumulate(this, 1, (prev, next) -> prev == this.maxBuffer ? this.maxBuffer : prev + next) == this.maxBuffer) {
            this.offerPastBufferSize(SubscriberApiUtils.wrapNull(item), this.signals);
        } else {
            this.offerSignal(SubscriberApiUtils.wrapNull(item));
        }
    }

    @Override
    public void terminate() {
        TerminalNotification terminal = TerminalNotification.complete();
        if (this.tryTerminate(terminal)) {
            this.offerSignal(terminal);
        }
    }

    @Override
    public void terminate(Throwable cause) {
        TerminalNotification terminal = TerminalNotification.error((Throwable)cause);
        if (this.tryTerminate(terminal)) {
            this.offerSignal(terminal);
        }
    }

    @Override
    public boolean tryConsume(ProcessorSignalsConsumer<T> consumer) {
        Object signal = this.signals.poll();
        if (AbstractPublisherProcessorSignalsHolder.consumeIfTerminal(consumer, signal)) {
            return true;
        }
        if (AbstractPublisherProcessorSignalsHolder.consumeNextItem(consumer, signal)) {
            bufferedUpdater.decrementAndGet(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryConsumeTerminal(ProcessorSignalsConsumer<T> consumer) {
        return AbstractPublisherProcessorSignalsHolder.consumeIfTerminal(consumer, this.signals.peek());
    }

    abstract void offerPastBufferSize(Object var1, Q var2);

    private void offerSignal(Object signal) {
        if (!this.signals.offer((Object)signal)) {
            throw new QueueFullException("publisher-processor-signals");
        }
    }
}

