/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AutoOnSubscribeSingleSubscriberFunction;
import io.servicetalk.concurrent.api.ConcurrentSingleSubscriberFunction;
import io.servicetalk.concurrent.api.NonResubscribeableSingleSubscriberFunction;
import io.servicetalk.concurrent.api.SequentialSingleSubscriberFunction;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SingleProcessor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestSingle<T>
extends Single<T>
implements SingleSource<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestSingle.class);
    private static final AtomicReferenceFieldUpdater<TestSingle, SingleSource.Subscriber> subscriberUpdater = AtomicReferenceFieldUpdater.newUpdater(TestSingle.class, SingleSource.Subscriber.class, "subscriber");
    private final Function<SingleSource.Subscriber<? super T>, SingleSource.Subscriber<? super T>> subscriberFunction;
    private final List<Throwable> exceptions = new CopyOnWriteArrayList<Throwable>();
    private volatile SingleSource.Subscriber<? super T> subscriber = new WaitingSubscriber<T>();

    public TestSingle() {
        this(new Builder().buildSubscriberFunction());
    }

    private TestSingle(Function<SingleSource.Subscriber<? super T>, SingleSource.Subscriber<? super T>> subscriberFunction) {
        this.subscriberFunction = Objects.requireNonNull(subscriberFunction);
    }

    public boolean isSubscribed() {
        return !(this.subscriber instanceof WaitingSubscriber);
    }

    protected void handleSubscribe(SingleSource.Subscriber<? super T> subscriber) {
        try {
            SingleSource.Subscriber<? super T> currSubscriber;
            SingleSource.Subscriber<? super T> newSubscriber = Objects.requireNonNull(this.subscriberFunction.apply(subscriber));
            while (!subscriberUpdater.compareAndSet(this, currSubscriber = this.subscriber, newSubscriber)) {
            }
            if (currSubscriber instanceof WaitingSubscriber) {
                WaitingSubscriber waiter = (WaitingSubscriber)currSubscriber;
                waiter.realSubscriber(newSubscriber);
            }
        }
        catch (Throwable t) {
            this.record(t);
        }
    }

    public void subscribe(SingleSource.Subscriber<? super T> subscriber) {
        this.subscribeInternal(subscriber);
    }

    public void onSubscribe(Cancellable cancellable) {
        SingleSource.Subscriber<T> subscriber = this.checkSubscriberAndExceptions();
        subscriber.onSubscribe(cancellable);
    }

    public void onSuccess(@Nullable T result) {
        SingleSource.Subscriber<T> subscriber = this.checkSubscriberAndExceptions();
        subscriber.onSuccess(result);
    }

    public void onError(Throwable t) {
        SingleSource.Subscriber<T> subscriber = this.checkSubscriberAndExceptions();
        subscriber.onError(t);
    }

    private SingleSource.Subscriber<? super T> checkSubscriberAndExceptions() {
        if (!this.exceptions.isEmpty()) {
            RuntimeException exception = new RuntimeException("Unexpected exception(s) encountered", this.exceptions.get(0));
            for (int i = 1; i < this.exceptions.size(); ++i) {
                exception.addSuppressed(this.exceptions.get(i));
            }
            throw exception;
        }
        return this.subscriber;
    }

    private void record(Throwable t) {
        Objects.requireNonNull(t);
        LOGGER.warn("Unexpected exception", t);
        this.exceptions.add(t);
    }

    private static final class WaitingSubscriber<T>
    implements SingleSource.Subscriber<T> {
        private final SingleProcessor<SingleSource.Subscriber<? super T>> realSubscriberSingle = new SingleProcessor();

        private WaitingSubscriber() {
        }

        public void onSubscribe(Cancellable cancellable) {
            this.waitForSubscriber().onSubscribe(cancellable);
        }

        public void onSuccess(@Nullable T t) {
            this.waitForSubscriber().onSuccess(t);
        }

        public void onError(Throwable t) {
            this.waitForSubscriber().onError(t);
        }

        void realSubscriber(SingleSource.Subscriber<? super T> subscriber) {
            this.realSubscriberSingle.onSuccess(subscriber);
        }

        private SingleSource.Subscriber<? super T> waitForSubscriber() {
            try {
                return (SingleSource.Subscriber)this.realSubscriberSingle.toFuture().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Builder<T> {
        @Nullable
        private Function<SingleSource.Subscriber<? super T>, SingleSource.Subscriber<? super T>> autoOnSubscribeFunction = new AutoOnSubscribeSingleSubscriberFunction<T>();
        private Function<SingleSource.Subscriber<? super T>, SingleSource.Subscriber<? super T>> subscriberCardinalityFunction = new SequentialSingleSubscriberFunction<T>();

        public Builder<T> concurrentSubscribers() {
            this.subscriberCardinalityFunction = new ConcurrentSingleSubscriberFunction<T>();
            return this;
        }

        public Builder<T> concurrentSubscribers(ConcurrentSingleSubscriberFunction<T> function) {
            this.subscriberCardinalityFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder<T> sequentialSubscribers() {
            this.subscriberCardinalityFunction = new SequentialSingleSubscriberFunction<T>();
            return this;
        }

        public Builder<T> sequentialSubscribers(SequentialSingleSubscriberFunction<T> function) {
            this.subscriberCardinalityFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder<T> singleSubscriber() {
            this.subscriberCardinalityFunction = new NonResubscribeableSingleSubscriberFunction<T>();
            return this;
        }

        public Builder<T> singleSubscriber(NonResubscribeableSingleSubscriberFunction<T> function) {
            this.subscriberCardinalityFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder<T> autoOnSubscribe() {
            this.autoOnSubscribeFunction = new AutoOnSubscribeSingleSubscriberFunction<T>();
            return this;
        }

        public Builder<T> autoOnSubscribe(AutoOnSubscribeSingleSubscriberFunction<T> function) {
            this.autoOnSubscribeFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder<T> disableAutoOnSubscribe() {
            this.autoOnSubscribeFunction = null;
            return this;
        }

        public TestSingle<T> build(Function<SingleSource.Subscriber<? super T>, SingleSource.Subscriber<? super T>> function) {
            return new TestSingle(function);
        }

        private Function<SingleSource.Subscriber<? super T>, SingleSource.Subscriber<? super T>> buildSubscriberFunction() {
            Function<SingleSource.Subscriber<? super T>, SingleSource.Subscriber<? super T>> subscriberFunction = this.autoOnSubscribeFunction;
            subscriberFunction = Builder.andThen(subscriberFunction, this.subscriberCardinalityFunction);
            assert (subscriberFunction != null);
            return subscriberFunction;
        }

        public TestSingle<T> build() {
            return new TestSingle(this.buildSubscriberFunction());
        }

        @Nullable
        private static <T> Function<SingleSource.Subscriber<? super T>, SingleSource.Subscriber<? super T>> andThen(@Nullable Function<SingleSource.Subscriber<? super T>, SingleSource.Subscriber<? super T>> first, @Nullable Function<SingleSource.Subscriber<? super T>, SingleSource.Subscriber<? super T>> second) {
            if (first == null) {
                return second;
            }
            if (second == null) {
                return first;
            }
            return first.andThen(second);
        }
    }
}

