/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AutoOnSubscribeCompletableSubscriberFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ConcurrentCompletableSubscriberFunction;
import io.servicetalk.concurrent.api.NonResubscribeableCompletableSubscriberFunction;
import io.servicetalk.concurrent.api.SequentialCompletableSubscriberFunction;
import io.servicetalk.concurrent.api.SingleProcessor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestCompletable
extends Completable
implements CompletableSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCompletable.class);
    private static final AtomicReferenceFieldUpdater<TestCompletable, CompletableSource.Subscriber> subscriberUpdater = AtomicReferenceFieldUpdater.newUpdater(TestCompletable.class, CompletableSource.Subscriber.class, "subscriber");
    private final Function<CompletableSource.Subscriber, CompletableSource.Subscriber> subscriberFunction;
    private final List<Throwable> exceptions = new CopyOnWriteArrayList<Throwable>();
    private volatile CompletableSource.Subscriber subscriber = new WaitingSubscriber();

    public TestCompletable() {
        this(new Builder().buildSubscriberFunction());
    }

    private TestCompletable(Function<CompletableSource.Subscriber, CompletableSource.Subscriber> subscriberFunction) {
        this.subscriberFunction = Objects.requireNonNull(subscriberFunction);
    }

    public boolean isSubscribed() {
        return !(this.subscriber instanceof WaitingSubscriber);
    }

    protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
        try {
            CompletableSource.Subscriber currSubscriber;
            CompletableSource.Subscriber newSubscriber = Objects.requireNonNull(this.subscriberFunction.apply(subscriber));
            while (!subscriberUpdater.compareAndSet(this, currSubscriber = this.subscriber, newSubscriber)) {
            }
            if (currSubscriber instanceof WaitingSubscriber) {
                WaitingSubscriber waiter = (WaitingSubscriber)currSubscriber;
                waiter.realSubscriber(newSubscriber);
            }
        }
        catch (Throwable t) {
            this.record(t);
        }
    }

    public void subscribe(CompletableSource.Subscriber subscriber) {
        this.subscribeInternal(subscriber);
    }

    public void onSubscribe(Cancellable cancellable) {
        CompletableSource.Subscriber subscriber = this.checkSubscriberAndExceptions();
        subscriber.onSubscribe(cancellable);
    }

    public void onComplete() {
        CompletableSource.Subscriber subscriber = this.checkSubscriberAndExceptions();
        subscriber.onComplete();
    }

    public void onError(Throwable t) {
        CompletableSource.Subscriber subscriber = this.checkSubscriberAndExceptions();
        subscriber.onError(t);
    }

    private CompletableSource.Subscriber checkSubscriberAndExceptions() {
        if (!this.exceptions.isEmpty()) {
            RuntimeException exception = new RuntimeException("Unexpected exception(s) encountered", this.exceptions.get(0));
            for (int i = 1; i < this.exceptions.size(); ++i) {
                exception.addSuppressed(this.exceptions.get(i));
            }
            throw exception;
        }
        return this.subscriber;
    }

    private void record(Throwable t) {
        Objects.requireNonNull(t);
        LOGGER.warn("Unexpected exception", t);
        this.exceptions.add(t);
    }

    private static final class WaitingSubscriber
    implements CompletableSource.Subscriber {
        private final SingleProcessor<CompletableSource.Subscriber> realSubscriberSingle = new SingleProcessor();

        private WaitingSubscriber() {
        }

        public void onSubscribe(Cancellable cancellable) {
            this.waitForSubscriber().onSubscribe(cancellable);
        }

        public void onComplete() {
            this.waitForSubscriber().onComplete();
        }

        public void onError(Throwable t) {
            this.waitForSubscriber().onError(t);
        }

        void realSubscriber(CompletableSource.Subscriber subscriber) {
            this.realSubscriberSingle.onSuccess((Object)subscriber);
        }

        private CompletableSource.Subscriber waitForSubscriber() {
            try {
                return (CompletableSource.Subscriber)this.realSubscriberSingle.toFuture().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Builder {
        @Nullable
        private Function<CompletableSource.Subscriber, CompletableSource.Subscriber> autoOnSubscribeFunction = new AutoOnSubscribeCompletableSubscriberFunction();
        private Function<CompletableSource.Subscriber, CompletableSource.Subscriber> subscriberCardinalityFunction = new SequentialCompletableSubscriberFunction();

        public Builder concurrentSubscribers() {
            this.subscriberCardinalityFunction = new ConcurrentCompletableSubscriberFunction();
            return this;
        }

        public Builder concurrentSubscribers(ConcurrentCompletableSubscriberFunction function) {
            this.subscriberCardinalityFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder sequentialSubscribers() {
            this.subscriberCardinalityFunction = new SequentialCompletableSubscriberFunction();
            return this;
        }

        public Builder sequentialSubscribers(SequentialCompletableSubscriberFunction function) {
            this.subscriberCardinalityFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder singleSubscriber() {
            this.subscriberCardinalityFunction = new NonResubscribeableCompletableSubscriberFunction();
            return this;
        }

        public Builder singleSubscriber(NonResubscribeableCompletableSubscriberFunction function) {
            this.subscriberCardinalityFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder autoOnSubscribe() {
            this.autoOnSubscribeFunction = new AutoOnSubscribeCompletableSubscriberFunction();
            return this;
        }

        public Builder autoOnSubscribe(AutoOnSubscribeCompletableSubscriberFunction function) {
            this.autoOnSubscribeFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder disableAutoOnSubscribe() {
            this.autoOnSubscribeFunction = null;
            return this;
        }

        public TestCompletable build(Function<CompletableSource.Subscriber, CompletableSource.Subscriber> function) {
            return new TestCompletable(function);
        }

        private Function<CompletableSource.Subscriber, CompletableSource.Subscriber> buildSubscriberFunction() {
            Function<CompletableSource.Subscriber, CompletableSource.Subscriber> subscriberFunction = this.autoOnSubscribeFunction;
            subscriberFunction = Builder.andThen(subscriberFunction, this.subscriberCardinalityFunction);
            assert (subscriberFunction != null);
            return subscriberFunction;
        }

        public TestCompletable build() {
            return new TestCompletable(this.buildSubscriberFunction());
        }

        @Nullable
        private static Function<CompletableSource.Subscriber, CompletableSource.Subscriber> andThen(@Nullable Function<CompletableSource.Subscriber, CompletableSource.Subscriber> first, @Nullable Function<CompletableSource.Subscriber, CompletableSource.Subscriber> second) {
            if (first == null) {
                return second;
            }
            if (second == null) {
                return first;
            }
            return first.andThen(second);
        }
    }
}

