/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.DelegatingSingleSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class SequentialSingleSubscriberFunction<T>
implements Function<SingleSource.Subscriber<? super T>, SingleSource.Subscriber<? super T>> {
    private final AtomicBoolean subscribed = new AtomicBoolean();
    @Nullable
    private volatile SingleSource.Subscriber<? super T> subscriber;

    @Override
    public SingleSource.Subscriber<? super T> apply(final SingleSource.Subscriber<? super T> subscriber) {
        if (!this.subscribed.compareAndSet(false, true)) {
            throw new IllegalStateException("Duplicate subscriber: " + subscriber);
        }
        this.subscriber = subscriber;
        return new DelegatingSingleSubscriber<T>(subscriber){

            @Override
            public void onSubscribe(Cancellable s) {
                super.onSubscribe(() -> {
                    this.reset(subscriber);
                    s.cancel();
                });
            }

            @Override
            public void onError(Throwable t) {
                this.reset(subscriber);
                super.onError(t);
            }

            @Override
            public void onSuccess(T result) {
                this.reset(subscriber);
                super.onSuccess(result);
            }

            private void reset(SingleSource.Subscriber<? super T> subscriber2) {
                if (SequentialSingleSubscriberFunction.this.subscriber == subscriber2) {
                    SequentialSingleSubscriberFunction.this.subscribed.set(false);
                }
            }
        };
    }

    @Nullable
    public SingleSource.Subscriber<? super T> subscriber() {
        return this.subscriber;
    }

    public boolean isSubscribed() {
        return this.subscribed.get();
    }
}

