/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.DelegatingCompletableSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class SequentialCompletableSubscriberFunction
implements Function<CompletableSource.Subscriber, CompletableSource.Subscriber> {
    private final AtomicBoolean subscribed = new AtomicBoolean();
    @Nullable
    private volatile CompletableSource.Subscriber subscriber;

    @Override
    public CompletableSource.Subscriber apply(final CompletableSource.Subscriber subscriber) {
        if (!this.subscribed.compareAndSet(false, true)) {
            throw new IllegalStateException("Duplicate subscriber: " + subscriber);
        }
        this.subscriber = subscriber;
        return new DelegatingCompletableSubscriber(subscriber){

            @Override
            public void onSubscribe(Cancellable s) {
                super.onSubscribe(() -> {
                    this.reset(subscriber);
                    s.cancel();
                });
            }

            @Override
            public void onError(Throwable t) {
                this.reset(subscriber);
                super.onError(t);
            }

            @Override
            public void onComplete() {
                this.reset(subscriber);
                super.onComplete();
            }

            private void reset(CompletableSource.Subscriber subscriber2) {
                if (SequentialCompletableSubscriberFunction.this.subscriber == subscriber2) {
                    SequentialCompletableSubscriberFunction.this.subscribed.set(false);
                }
            }
        };
    }

    @Nullable
    public CompletableSource.Subscriber subscriber() {
        return this.subscriber;
    }

    public boolean isSubscribed() {
        return this.subscribed.get();
    }
}

