/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.DefaultThreadFactory;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.TestExecutor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;

public final class ExecutorRule<E extends Executor>
extends ExternalResource {
    private final Supplier<E> eSupplier;
    private E executor;

    private ExecutorRule(Supplier<E> eSupplier) {
        this.eSupplier = eSupplier;
    }

    public static ExecutorRule<Executor> newRule() {
        return new ExecutorRule<Executor>(Executors::newCachedThreadExecutor);
    }

    public static ExecutorRule<TestExecutor> withTestExecutor() {
        return new ExecutorRule<TestExecutor>(TestExecutor::new);
    }

    public static ExecutorRule<Executor> withExecutor(Supplier<Executor> executorSupplier) {
        return new ExecutorRule<Executor>(executorSupplier);
    }

    public static ExecutorRule<Executor> withNamePrefix(String namePrefix) {
        return new ExecutorRule<Executor>(() -> Executors.newCachedThreadExecutor((ThreadFactory)new DefaultThreadFactory(namePrefix, true, 5)));
    }

    public E executor() {
        return this.executor;
    }

    protected void before() {
        this.executor = (Executor)this.eSupplier.get();
    }

    protected void after() {
        try {
            this.executor.closeAsync().toFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

