/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisher;
import io.servicetalk.concurrent.internal.AutoClosableUtils;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FromIterablePublisher<T>
extends AbstractSynchronousPublisher<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FromIterablePublisher.class);
    private final Iterable<? extends T> iterable;

    FromIterablePublisher(Iterable<? extends T> iterable) {
        this.iterable = Objects.requireNonNull(iterable);
    }

    @Override
    void doSubscribe(PublisherSource.Subscriber<? super T> subscriber) {
        try {
            subscriber.onSubscribe(new FromIterableSubscription<T, Iterator<? extends T>>(this.iterable.iterator(), subscriber));
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)t);
        }
    }

    static class FromIterableSubscription<T, I extends Iterator<? extends T>>
    implements PublisherSource.Subscription {
        private final I iterator;
        private final PublisherSource.Subscriber<? super T> subscriber;
        private long requestN;
        private boolean ignoreRequests;

        FromIterableSubscription(I iterator, PublisherSource.Subscriber<? super T> subscriber) {
            this.iterator = (Iterator)Objects.requireNonNull(iterator);
            this.subscriber = subscriber;
        }

        boolean hasNext(I iterator) throws TimeoutException {
            return iterator.hasNext();
        }

        T next(I iterator) throws TimeoutException {
            return (T)iterator.next();
        }

        public final void request(long n) {
            boolean lastHasNext;
            if (!SubscriberUtils.isRequestNValid((long)n) && this.requestN >= 0L) {
                this.sendOnError(SubscriberUtils.newExceptionForInvalidRequestN((long)n));
                return;
            }
            this.requestN = FlowControlUtils.addWithOverflowProtection((long)this.requestN, (long)n);
            if (this.ignoreRequests) {
                return;
            }
            this.ignoreRequests = true;
            try {
                while (lastHasNext = this.hasNext(this.iterator)) {
                    this.subscriber.onNext(this.next(this.iterator));
                    if (--this.requestN > 0L) continue;
                }
                if (this.requestN == 0L && lastHasNext) {
                    lastHasNext = this.hasNext(this.iterator);
                }
            }
            catch (Throwable cause) {
                this.sendOnError(cause);
                return;
            }
            if (this.requestN >= 0L) {
                this.ignoreRequests = false;
            }
            if (!lastHasNext) {
                this.sendOnComplete();
            }
        }

        public final void cancel() {
            this.cleanupForCancel();
            if (this.iterator instanceof AutoCloseable) {
                AutoClosableUtils.closeAndReThrowUnchecked((AutoCloseable)((AutoCloseable)this.iterator));
            }
        }

        private void cleanupForCancel() {
            this.requestN = -1L;
            this.ignoreRequests = true;
        }

        private void sendOnError(Throwable cause) {
            this.cancel();
            try {
                this.subscriber.onError(cause);
            }
            catch (Throwable t) {
                LOGGER.info("Ignoring exception from onError of Subscriber {}.", this.subscriber, (Object)t);
            }
        }

        private void sendOnComplete() {
            this.cleanupForCancel();
            try {
                this.subscriber.onComplete();
            }
            catch (Throwable t) {
                LOGGER.info("Ignoring exception from onComplete of Subscriber {}.", this.subscriber, (Object)t);
            }
        }
    }
}

