/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.api.AbstractOffloaderAwareExecutor;
import io.servicetalk.concurrent.api.DefaultThreadFactory;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SignalOffloaderFactory;
import io.servicetalk.concurrent.internal.SignalOffloaders;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

final class DefaultExecutor
extends AbstractOffloaderAwareExecutor
implements Consumer<Runnable> {
    private static final long DEFAULT_KEEP_ALIVE_TIME_SECONDS = 60L;
    private static final ScheduledExecutorService GLOBAL_SINGLE_THREADED_SCHEDULED_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("servicetalk-global-scheduler", true, 5));
    private static final RejectedExecutionHandler DEFAULT_REJECTION_HANDLER = new ThreadPoolExecutor.AbortPolicy();
    private final InternalExecutor executor;
    private final InternalScheduler scheduler;
    private final SignalOffloaderFactory offloaderFactory;

    DefaultExecutor(int coreSize, int maxSize, ThreadFactory threadFactory) {
        this(new ThreadPoolExecutor(coreSize, maxSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, DEFAULT_REJECTION_HANDLER));
    }

    DefaultExecutor(java.util.concurrent.Executor jdkExecutor) {
        this(jdkExecutor, true);
    }

    DefaultExecutor(java.util.concurrent.Executor jdkExecutor, boolean interruptOnCancel) {
        this(jdkExecutor, new SingleThreadedScheduler(jdkExecutor), interruptOnCancel);
    }

    DefaultExecutor(java.util.concurrent.Executor jdkExecutor, ScheduledExecutorService scheduler) {
        this(jdkExecutor, scheduler, true);
    }

    DefaultExecutor(java.util.concurrent.Executor jdkExecutor, ScheduledExecutorService scheduler, boolean interruptOnCancel) {
        this(jdkExecutor, DefaultExecutor.newScheduler(scheduler, interruptOnCancel), interruptOnCancel);
    }

    private DefaultExecutor(@Nullable java.util.concurrent.Executor jdkExecutor, @Nullable InternalScheduler scheduler, boolean interruptOnCancel) {
        if (jdkExecutor == null) {
            if (scheduler != null) {
                scheduler.run();
            }
            throw new NullPointerException("jdkExecutor");
        }
        if (scheduler == null) {
            DefaultExecutor.shutdownExecutor(jdkExecutor);
            throw new NullPointerException("scheduler");
        }
        this.executor = DefaultExecutor.newInternalExecutor(jdkExecutor, interruptOnCancel);
        this.scheduler = scheduler;
        this.offloaderFactory = SignalOffloaders.defaultOffloaderFactory();
    }

    public Cancellable execute(Runnable task) {
        return (Cancellable)this.executor.apply(task);
    }

    public Cancellable schedule(Runnable task, long duration, TimeUnit unit) {
        return this.scheduler.apply(task, duration, unit);
    }

    @Override
    void doClose() {
        try {
            this.executor.run();
        }
        finally {
            this.scheduler.run();
        }
    }

    public SignalOffloader newSignalOffloader(Executor executor) {
        return this.offloaderFactory.newSignalOffloader(executor);
    }

    public boolean hasThreadAffinity() {
        return this.offloaderFactory.hasThreadAffinity();
    }

    @Override
    public void accept(Runnable runnable) {
        this.execute(runnable);
    }

    private static void shutdownExecutor(java.util.concurrent.Executor jdkExecutor) {
        if (jdkExecutor instanceof ExecutorService) {
            ((ExecutorService)jdkExecutor).shutdown();
        } else if (jdkExecutor instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)jdkExecutor)).close();
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected exception while closing executor: " + jdkExecutor, e);
            }
        }
    }

    private static InternalExecutor newInternalExecutor(final java.util.concurrent.Executor jdkExecutor, final boolean interruptOnCancel) {
        if (jdkExecutor instanceof ExecutorService) {
            return new InternalExecutor(){
                private final ExecutorService service;
                {
                    this.service = (ExecutorService)jdkExecutor;
                }

                @Override
                public void run() {
                    this.service.shutdown();
                }

                @Override
                public Cancellable apply(Runnable runnable) {
                    Future<?> future = this.service.submit(runnable);
                    return () -> future.cancel(interruptOnCancel);
                }
            };
        }
        return new InternalExecutor(){

            @Override
            public void run() {
                DefaultExecutor.shutdownExecutor(jdkExecutor);
            }

            @Override
            public Cancellable apply(Runnable runnable) {
                jdkExecutor.execute(runnable);
                return Cancellable.IGNORE_CANCEL;
            }
        };
    }

    private static InternalScheduler newScheduler(final ScheduledExecutorService service, final boolean interruptOnCancel) {
        return new InternalScheduler(){

            @Override
            public void run() {
                service.shutdown();
            }

            @Override
            public Cancellable apply(Runnable task, long delay, TimeUnit unit) {
                ScheduledFuture<?> future = service.schedule(task, delay, unit);
                return () -> future.cancel(interruptOnCancel);
            }
        };
    }

    private static final class SingleThreadedScheduler
    implements InternalScheduler {
        private final java.util.concurrent.Executor offloadExecutor;

        SingleThreadedScheduler(java.util.concurrent.Executor offloadExecutor) {
            this.offloadExecutor = offloadExecutor;
        }

        @Override
        public void run() {
        }

        @Override
        public Cancellable apply(Runnable task, long delay, TimeUnit unit) {
            ScheduledFuture<?> future = GLOBAL_SINGLE_THREADED_SCHEDULED_EXECUTOR.schedule(() -> this.offloadExecutor.execute(task), delay, unit);
            return () -> future.cancel(true);
        }
    }

    private static interface InternalScheduler
    extends Runnable {
        public Cancellable apply(Runnable var1, long var2, TimeUnit var4);
    }

    private static interface InternalExecutor
    extends Function<Runnable, Cancellable>,
    Runnable {
    }
}

