/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AutoOnSubscribePublisherSubscriberFunction;
import io.servicetalk.concurrent.api.ConcurrentPublisherSubscriberFunction;
import io.servicetalk.concurrent.api.DemandCheckingSubscriberFunction;
import io.servicetalk.concurrent.api.NonResubscribeablePublisherSubscriberFunction;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SequentialPublisherSubscriberFunction;
import io.servicetalk.concurrent.api.SingleProcessor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestPublisher<T>
extends Publisher<T>
implements PublisherSource<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestPublisher.class);
    private static final AtomicReferenceFieldUpdater<TestPublisher, PublisherSource.Subscriber> subscriberUpdater = AtomicReferenceFieldUpdater.newUpdater(TestPublisher.class, PublisherSource.Subscriber.class, "subscriber");
    private final Function<PublisherSource.Subscriber<? super T>, PublisherSource.Subscriber<? super T>> subscriberFunction;
    private final List<Throwable> exceptions = new CopyOnWriteArrayList<Throwable>();
    private volatile PublisherSource.Subscriber<? super T> subscriber = new WaitingSubscriber<T>();

    public TestPublisher() {
        this(new Builder().buildSubscriberFunction());
    }

    private TestPublisher(Function<PublisherSource.Subscriber<? super T>, PublisherSource.Subscriber<? super T>> subscriberFunction) {
        this.subscriberFunction = Objects.requireNonNull(subscriberFunction);
    }

    public boolean isSubscribed() {
        return !(this.subscriber instanceof WaitingSubscriber);
    }

    protected void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber) {
        try {
            PublisherSource.Subscriber<? super T> currSubscriber;
            PublisherSource.Subscriber<? super T> newSubscriber = Objects.requireNonNull(this.subscriberFunction.apply(subscriber));
            while (!subscriberUpdater.compareAndSet(this, currSubscriber = this.subscriber, newSubscriber)) {
            }
            if (currSubscriber instanceof WaitingSubscriber) {
                WaitingSubscriber waiter = (WaitingSubscriber)currSubscriber;
                waiter.realSubscriber(newSubscriber);
            }
        }
        catch (Throwable t) {
            this.record(t);
        }
    }

    public void subscribe(PublisherSource.Subscriber<? super T> subscriber) {
        this.subscribeInternal(subscriber);
    }

    public void onSubscribe(PublisherSource.Subscription subscription) {
        PublisherSource.Subscriber<T> subscriber = this.checkSubscriberAndExceptions();
        subscriber.onSubscribe(subscription);
    }

    @SafeVarargs
    public final void onNext(T ... items) {
        PublisherSource.Subscriber<T> subscriber = this.checkSubscriberAndExceptions();
        try {
            if (items == null) {
                subscriber.onNext(null);
            } else {
                for (T item : items) {
                    subscriber.onNext(item);
                }
            }
        }
        catch (Throwable cause) {
            this.onError(cause);
        }
    }

    public void onComplete() {
        PublisherSource.Subscriber<T> subscriber = this.checkSubscriberAndExceptions();
        subscriber.onComplete();
    }

    public void onError(Throwable t) {
        PublisherSource.Subscriber<T> subscriber = this.checkSubscriberAndExceptions();
        subscriber.onError(t);
    }

    private PublisherSource.Subscriber<? super T> checkSubscriberAndExceptions() {
        if (!this.exceptions.isEmpty()) {
            RuntimeException exception = new RuntimeException("Unexpected exception(s) encountered", this.exceptions.get(0));
            for (int i = 1; i < this.exceptions.size(); ++i) {
                exception.addSuppressed(this.exceptions.get(i));
            }
            throw exception;
        }
        return this.subscriber;
    }

    private void record(Throwable t) {
        Objects.requireNonNull(t);
        LOGGER.warn("Unexpected exception", t);
        this.exceptions.add(t);
    }

    private static final class WaitingSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final SingleProcessor<PublisherSource.Subscriber<? super T>> realSubscriberSingle = new SingleProcessor();

        private WaitingSubscriber() {
        }

        public void onSubscribe(PublisherSource.Subscription subscription) {
            this.waitForSubscriber().onSubscribe(subscription);
        }

        public void onNext(@Nullable T t) {
            this.waitForSubscriber().onNext(t);
        }

        public void onError(Throwable t) {
            this.waitForSubscriber().onError(t);
        }

        public void onComplete() {
            this.waitForSubscriber().onComplete();
        }

        void realSubscriber(PublisherSource.Subscriber<? super T> subscriber) {
            this.realSubscriberSingle.onSuccess(subscriber);
        }

        private PublisherSource.Subscriber<? super T> waitForSubscriber() {
            try {
                return (PublisherSource.Subscriber)this.realSubscriberSingle.toFuture().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Builder<T> {
        @Nullable
        private Function<PublisherSource.Subscriber<? super T>, PublisherSource.Subscriber<? super T>> demandCheckingSubscriberFunction;
        @Nullable
        private Function<PublisherSource.Subscriber<? super T>, PublisherSource.Subscriber<? super T>> autoOnSubscribeSubscriberFunction = new AutoOnSubscribePublisherSubscriberFunction<T>();
        private Function<PublisherSource.Subscriber<? super T>, PublisherSource.Subscriber<? super T>> subscriberCardinalityFunction = new SequentialPublisherSubscriberFunction<T>();

        public Builder<T> concurrentSubscribers() {
            this.subscriberCardinalityFunction = new ConcurrentPublisherSubscriberFunction<T>();
            return this;
        }

        public Builder<T> concurrentSubscribers(ConcurrentPublisherSubscriberFunction<T> function) {
            this.subscriberCardinalityFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder<T> sequentialSubscribers() {
            this.subscriberCardinalityFunction = new SequentialPublisherSubscriberFunction<T>();
            return this;
        }

        public Builder<T> sequentialSubscribers(SequentialPublisherSubscriberFunction<T> function) {
            this.subscriberCardinalityFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder<T> singleSubscriber() {
            this.subscriberCardinalityFunction = new NonResubscribeablePublisherSubscriberFunction<T>();
            return this;
        }

        public Builder<T> singleSubscriber(NonResubscribeablePublisherSubscriberFunction<T> function) {
            this.subscriberCardinalityFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder<T> enableDemandCheck() {
            this.demandCheckingSubscriberFunction = new DemandCheckingSubscriberFunction<T>();
            return this;
        }

        public Builder<T> enableDemandCheck(DemandCheckingSubscriberFunction<T> function) {
            this.demandCheckingSubscriberFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder<T> disableDemandCheck() {
            this.demandCheckingSubscriberFunction = null;
            return this;
        }

        public Builder<T> autoOnSubscribe() {
            this.autoOnSubscribeSubscriberFunction = new AutoOnSubscribePublisherSubscriberFunction<T>();
            return this;
        }

        public Builder<T> autoOnSubscribe(AutoOnSubscribePublisherSubscriberFunction<T> function) {
            this.autoOnSubscribeSubscriberFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder<T> disableAutoOnSubscribe() {
            this.autoOnSubscribeSubscriberFunction = null;
            return this;
        }

        public TestPublisher<T> build(Function<PublisherSource.Subscriber<? super T>, PublisherSource.Subscriber<? super T>> function) {
            return new TestPublisher(function);
        }

        private Function<PublisherSource.Subscriber<? super T>, PublisherSource.Subscriber<? super T>> buildSubscriberFunction() {
            Function<PublisherSource.Subscriber<? super T>, PublisherSource.Subscriber<? super T>> subscriberFunction = this.demandCheckingSubscriberFunction;
            subscriberFunction = Builder.andThen(subscriberFunction, this.autoOnSubscribeSubscriberFunction);
            subscriberFunction = Builder.andThen(subscriberFunction, this.subscriberCardinalityFunction);
            assert (subscriberFunction != null);
            return subscriberFunction;
        }

        public TestPublisher<T> build() {
            return new TestPublisher(this.buildSubscriberFunction());
        }

        @Nullable
        private static <T> Function<PublisherSource.Subscriber<? super T>, PublisherSource.Subscriber<? super T>> andThen(@Nullable Function<PublisherSource.Subscriber<? super T>, PublisherSource.Subscriber<? super T>> first, @Nullable Function<PublisherSource.Subscriber<? super T>, PublisherSource.Subscriber<? super T>> second) {
            if (first == null) {
                return second;
            }
            if (second == null) {
                return first;
            }
            return first.andThen(second);
        }
    }
}

