/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingCompletableSubscriber
implements CompletableSource.Subscriber {
    private final Logger logger;
    private final CompletableSource.Subscriber delegate;

    public LoggingCompletableSubscriber(String name, CompletableSource.Subscriber delegate) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.delegate = delegate;
    }

    public void onSubscribe(Cancellable c) {
        this.logger.info("onSubscribe({})", (Object)c);
        this.delegate.onSubscribe(() -> {
            this.logger.info("cancel()");
            c.cancel();
        });
    }

    public void onComplete() {
        this.logger.info("onComplete()");
        this.delegate.onComplete();
    }

    public void onError(Throwable t) {
        this.logger.info("onError({})", (Object)t, null);
        this.delegate.onError(t);
    }
}

