/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public final class ConcurrentCompletableSubscriberFunction
implements Function<CompletableSource.Subscriber, CompletableSource.Subscriber> {
    private final List<CompletableSource.Subscriber> subscribers = new CopyOnWriteArrayList<CompletableSource.Subscriber>();
    private final CompletableSource.Subscriber listSubscriber = new CompletableSource.Subscriber(){

        public void onSubscribe(Cancellable c) {
            for (CompletableSource.Subscriber subscriber : ConcurrentCompletableSubscriberFunction.this.subscribers) {
                subscriber.onSubscribe(c);
            }
        }

        public void onComplete() {
            for (CompletableSource.Subscriber subscriber : ConcurrentCompletableSubscriberFunction.this.subscribers) {
                subscriber.onComplete();
            }
        }

        public void onError(Throwable t) {
            for (CompletableSource.Subscriber subscriber : ConcurrentCompletableSubscriberFunction.this.subscribers) {
                subscriber.onError(t);
            }
        }
    };

    @Override
    public CompletableSource.Subscriber apply(CompletableSource.Subscriber subscriber) {
        this.subscribers.add(subscriber);
        return this.listSubscriber;
    }

    public List<CompletableSource.Subscriber> subscribers() {
        return new ArrayList<CompletableSource.Subscriber>(this.subscribers);
    }
}

