/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractAsynchronousSingleOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class SingleFlatMapSingle<T, R>
extends AbstractAsynchronousSingleOperator<T, R> {
    private final Function<? super T, ? extends Single<? extends R>> nextFactory;

    SingleFlatMapSingle(Single<T> first, Function<? super T, ? extends Single<? extends R>> nextFactory, Executor executor) {
        super(first, executor);
        this.nextFactory = Objects.requireNonNull(nextFactory);
    }

    @Override
    public SingleSource.Subscriber<? super T> apply(SingleSource.Subscriber<? super R> subscriber) {
        return new SubscriberImpl<T, R>(subscriber, this.nextFactory);
    }

    private static final class SubscriberImpl<T, R>
    implements SingleSource.Subscriber<T> {
        private final SingleSource.Subscriber<? super R> subscriber;
        private final Function<? super T, ? extends Single<? extends R>> nextFactory;
        @Nullable
        private SequentialCancellable sequentialCancellable;

        SubscriberImpl(SingleSource.Subscriber<? super R> subscriber, Function<? super T, ? extends Single<? extends R>> nextFactory) {
            this.subscriber = subscriber;
            this.nextFactory = nextFactory;
        }

        public void onSubscribe(Cancellable cancellable) {
            if (this.sequentialCancellable == null) {
                this.sequentialCancellable = new SequentialCancellable(cancellable);
                this.subscriber.onSubscribe((Cancellable)this.sequentialCancellable);
            } else {
                cancellable.cancel();
            }
        }

        public void onSuccess(@Nullable T result) {
            Single<R> next;
            assert (this.sequentialCancellable != null);
            try {
                next = Objects.requireNonNull(this.nextFactory.apply(result));
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return;
            }
            next.subscribeInternal(new SingleSource.Subscriber<R>(){

                public void onSubscribe(Cancellable cancellable) {
                    sequentialCancellable.nextCancellable(cancellable);
                }

                public void onSuccess(@Nullable R result) {
                    subscriber.onSuccess(result);
                }

                public void onError(Throwable t) {
                    subscriber.onError(t);
                }
            });
        }

        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }
    }
}

