/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CancellableThenSubscription;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class SingleConcatWithPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Single<? extends T> original;
    private final Publisher<? extends T> next;

    SingleConcatWithPublisher(Single<? extends T> original, Publisher<? extends T> next, Executor executor) {
        super(executor);
        this.original = original;
        this.next = next;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ConcatSubscriber<T>(subscriber, this.next), signalOffloader, contextMap, contextProvider);
    }

    private static final class ConcatSubscriber<T>
    extends CancellableThenSubscription
    implements SingleSource.Subscriber<T>,
    PublisherSource.Subscriber<T> {
        private static final Object INITIAL = new Object();
        private static final Object REQUESTED = new Object();
        private static final Object CANCELLED = new Object();
        private static final AtomicReferenceFieldUpdater<ConcatSubscriber, Object> mayBeResultUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcatSubscriber.class, Object.class, "mayBeResult");
        private final PublisherSource.Subscriber<? super T> target;
        private final Publisher<? extends T> next;
        @Nullable
        private volatile Object mayBeResult = INITIAL;

        ConcatSubscriber(PublisherSource.Subscriber<? super T> subscriber, Publisher<? extends T> next) {
            this.target = subscriber;
            this.next = next;
        }

        public void onSubscribe(Cancellable cancellable) {
            this.setCancellable(cancellable);
            this.target.onSubscribe((PublisherSource.Subscription)this);
        }

        public void onSuccess(@Nullable T result) {
            Object oldValue;
            do {
                if ((oldValue = this.mayBeResult) != REQUESTED) continue;
                this.emitSingleSuccessToTarget(result);
                break;
            } while (oldValue != CANCELLED && !mayBeResultUpdater.compareAndSet(this, INITIAL, result));
        }

        public void onComplete() {
            this.target.onComplete();
        }

        public void onSubscribe(PublisherSource.Subscription subscription) {
            this.setSubscription(subscription);
        }

        public void onNext(@Nullable T t) {
            this.target.onNext(t);
        }

        public void onError(Throwable t) {
            this.target.onError(t);
        }

        @Override
        public void request(long n) {
            block2: {
                Object oldVal;
                do {
                    if ((oldVal = this.mayBeResult) != REQUESTED && oldVal != CANCELLED) continue;
                    super.request(n);
                    break block2;
                } while (!mayBeResultUpdater.compareAndSet(this, oldVal, REQUESTED));
                if (oldVal != INITIAL) {
                    Object tVal = oldVal;
                    this.emitSingleSuccessToTarget(tVal);
                }
                if (n == 1L) break block2;
                super.request(n > 0L ? n - 1L : n);
            }
        }

        @Override
        public void cancel() {
            this.mayBeResult = CANCELLED;
            super.cancel();
        }

        private void emitSingleSuccessToTarget(@Nullable T result) {
            this.target.onNext(result);
            this.next.subscribeInternal(this);
        }
    }
}

