/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractAsynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class PublisherConcatWithSingle<T>
extends AbstractAsynchronousPublisherOperator<T, T> {
    private final Single<? extends T> next;

    PublisherConcatWithSingle(Publisher<T> original, Single<? extends T> next, Executor executor) {
        super(original, executor);
        this.next = Objects.requireNonNull(next);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new ConcatSubscriber<T>(subscriber, this.next);
    }

    private static final class SingleResult<T> {
        @Nullable
        private final T result;

        SingleResult(@Nullable T result) {
            this.result = result;
        }

        @Nullable
        static <T> T fromRaw(Object resultAsObject) {
            return ((SingleResult)resultAsObject).result;
        }
    }

    private static final class CancellableWithOutstandingDemand
    implements Cancellable {
        private final Cancellable cancellable;

        CancellableWithOutstandingDemand(Cancellable cancellable) {
            this.cancellable = cancellable;
        }

        public void cancel() {
            this.cancellable.cancel();
        }
    }

    private static final class ConcatSubscriber<T>
    implements SingleSource.Subscriber<T>,
    PublisherSource.Subscriber<T>,
    PublisherSource.Subscription {
        private static final Object CANCELLED = new Object();
        private static final Object TERMINATED = new Object();
        private static final AtomicReferenceFieldUpdater<ConcatSubscriber, Object> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcatSubscriber.class, Object.class, "state");
        private static final AtomicLongFieldUpdater<ConcatSubscriber> requestNUpdater = AtomicLongFieldUpdater.newUpdater(ConcatSubscriber.class, "requestN");
        private final PublisherSource.Subscriber<? super T> target;
        private final Single<? extends T> next;
        private boolean nextSubscribed;
        @Nullable
        private volatile Object state;
        private volatile long requestN;

        ConcatSubscriber(PublisherSource.Subscriber<? super T> target, Single<? extends T> next) {
            this.target = target;
            this.next = next;
        }

        public void onSubscribe(PublisherSource.Subscription s) {
            this.state = s;
            this.target.onSubscribe((PublisherSource.Subscription)this);
        }

        public void onNext(T t) {
            requestNUpdater.decrementAndGet(this);
            this.target.onNext(t);
        }

        public void onError(Throwable t) {
            this.target.onError(t);
        }

        public void onSubscribe(Cancellable cancellable) {
            Object s;
            do {
                if ((s = this.state) != CANCELLED) continue;
                cancellable.cancel();
                break;
            } while (!stateUpdater.compareAndSet(this, s, cancellable));
        }

        public void onSuccess(@Nullable T result) {
            Object s;
            long requestNBeforeDecrement = requestNUpdater.getAndDecrement(this);
            while ((s = this.state) != CANCELLED && s != TERMINATED) {
                if (requestNBeforeDecrement > 0L) {
                    if (!stateUpdater.compareAndSet(this, s, TERMINATED)) continue;
                    this.terminateTarget(result);
                    break;
                }
                if (requestNBeforeDecrement == 0L) {
                    if (!stateUpdater.compareAndSet(this, s, new SingleResult<T>(result))) continue;
                    if (!(s instanceof CancellableWithOutstandingDemand)) break;
                    requestNBeforeDecrement = this.requestN;
                    assert (requestNBeforeDecrement != 0L);
                    continue;
                }
                if (!stateUpdater.compareAndSet(this, s, TERMINATED)) continue;
                this.target.onError((Throwable)SubscriberUtils.newExceptionForInvalidRequestN((long)requestNBeforeDecrement));
            }
        }

        public void onComplete() {
            if (this.nextSubscribed) {
                this.target.onComplete();
            } else {
                this.nextSubscribed = true;
                this.next.subscribeInternal(this);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void request(long n) {
            long requestNPostUpdate;
            if (SubscriberUtils.isRequestNValid((long)n)) {
                requestNPostUpdate = requestNUpdater.accumulateAndGet(this, n, FlowControlUtils::addWithOverflowProtectionIfGtEqNegativeOne);
            } else {
                this.requestN = requestNPostUpdate = ConcatSubscriber.sanitizeInvalidRequestN(n);
            }
            while (true) {
                Object s;
                if ((s = this.state) instanceof PublisherSource.Subscription) {
                    ((PublisherSource.Subscription)s).request(n);
                    return;
                }
                if (s instanceof SingleResult) {
                    if (!stateUpdater.compareAndSet(this, s, TERMINATED)) continue;
                    if (requestNPostUpdate >= 0L) {
                        this.terminateTarget(SingleResult.fromRaw(s));
                        return;
                    }
                    this.target.onError((Throwable)SubscriberUtils.newExceptionForInvalidRequestN((long)requestNPostUpdate));
                    return;
                }
                if (!(s instanceof Cancellable) || s instanceof CancellableWithOutstandingDemand || stateUpdater.compareAndSet(this, s, new CancellableWithOutstandingDemand((Cancellable)s))) return;
            }
        }

        public void cancel() {
            Object s;
            while ((s = this.state) != CANCELLED && s != TERMINATED) {
                if (!stateUpdater.compareAndSet(this, s, CANCELLED)) continue;
                if (!(s instanceof Cancellable)) break;
                ((Cancellable)s).cancel();
                break;
            }
        }

        private void terminateTarget(@Nullable T t) {
            try {
                this.target.onNext(t);
            }
            catch (Throwable cause) {
                this.target.onError(cause);
                return;
            }
            this.target.onComplete();
        }

        private static long sanitizeInvalidRequestN(long n) {
            return n >= -1L ? -2L : (n == Long.MIN_VALUE ? -9223372036854775807L : n);
        }
    }
}

