/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.AutoClosableUtils;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.TerminalNotification;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PublisherConcatMapIterable<T, U>
extends AbstractSynchronousPublisherOperator<T, U> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublisherConcatMapIterable.class);
    private final Function<? super T, ? extends Iterable<? extends U>> mapper;

    PublisherConcatMapIterable(Publisher<T> original, Function<? super T, ? extends Iterable<? extends U>> mapper, Executor executor) {
        super(original, executor);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super U> subscriber) {
        return new FlatMapIterableSubscriber<T, U>(this.mapper, subscriber);
    }

    private static final class FlatMapIterableSubscriber<T, U>
    implements PublisherSource.Subscriber<T>,
    PublisherSource.Subscription {
        private static final AtomicLongFieldUpdater<FlatMapIterableSubscriber> requestNUpdater = AtomicLongFieldUpdater.newUpdater(FlatMapIterableSubscriber.class, "requestN");
        private static final AtomicIntegerFieldUpdater<FlatMapIterableSubscriber> emittingUpdater = AtomicIntegerFieldUpdater.newUpdater(FlatMapIterableSubscriber.class, "emitting");
        private final Function<? super T, ? extends Iterable<? extends U>> mapper;
        private final PublisherSource.Subscriber<? super U> target;
        @Nullable
        private volatile PublisherSource.Subscription sourceSubscription;
        @Nullable
        private volatile TerminalNotification terminalNotification;
        private volatile Iterator<? extends U> currentIterator = Collections.emptyIterator();
        private volatile long requestN;
        private volatile int emitting;

        FlatMapIterableSubscriber(Function<? super T, ? extends Iterable<? extends U>> mapper, PublisherSource.Subscriber<? super U> target) {
            this.target = target;
            this.mapper = mapper;
        }

        public void onSubscribe(PublisherSource.Subscription s) {
            if (SubscriberUtils.checkDuplicateSubscription((PublisherSource.Subscription)this.sourceSubscription, (PublisherSource.Subscription)s)) {
                this.sourceSubscription = s;
                this.target.onSubscribe((PublisherSource.Subscription)this);
            }
        }

        public void onNext(T u) {
            PublisherSource.Subscription sourceSubscription = this.sourceSubscription;
            assert (sourceSubscription != null);
            Iterator<U> currentIterator = Objects.requireNonNull(this.mapper.apply(u).iterator());
            this.currentIterator = currentIterator;
            this.tryDrainIterator(currentIterator, sourceSubscription, this.terminalNotification, this.requestN, ErrorHandlingStrategyInDrain.Throw);
        }

        public void onError(Throwable t) {
            TerminalNotification terminalNotification;
            PublisherSource.Subscription sourceSubscription = this.sourceSubscription;
            assert (sourceSubscription != null);
            this.terminalNotification = terminalNotification = TerminalNotification.error((Throwable)t);
            this.tryDrainIterator(this.currentIterator, sourceSubscription, terminalNotification, this.requestN, ErrorHandlingStrategyInDrain.Propagate);
        }

        public void onComplete() {
            TerminalNotification terminalNotification;
            PublisherSource.Subscription sourceSubscription = this.sourceSubscription;
            assert (sourceSubscription != null);
            this.terminalNotification = terminalNotification = TerminalNotification.complete();
            this.tryDrainIterator(this.currentIterator, sourceSubscription, terminalNotification, this.requestN, ErrorHandlingStrategyInDrain.Propagate);
        }

        public void request(long n) {
            PublisherSource.Subscription sourceSubscription = this.sourceSubscription;
            assert (sourceSubscription != null);
            if (!SubscriberUtils.isRequestNValid((long)n)) {
                sourceSubscription.request(n);
            } else {
                this.tryDrainIterator(this.currentIterator, sourceSubscription, this.terminalNotification, requestNUpdater.accumulateAndGet(this, n, FlowControlUtils::addWithOverflowProtectionIfNotNegative), ErrorHandlingStrategyInDrain.PropagateAndCancel);
            }
        }

        public void cancel() {
            PublisherSource.Subscription sourceSubscription = this.sourceSubscription;
            assert (sourceSubscription != null);
            if (requestNUpdater.getAndSet(this, -1L) >= 0L && emittingUpdater.compareAndSet(this, 0, 1)) {
                this.doCancel(sourceSubscription);
            }
        }

        private void doCancel(PublisherSource.Subscription sourceSubscription) {
            Iterator<? extends U> currentIterator = this.currentIterator;
            this.currentIterator = EmptyIterator.instance();
            if (currentIterator instanceof AutoCloseable) {
                AutoClosableUtils.closeAndReThrowUnchecked((AutoCloseable)((AutoCloseable)((Object)currentIterator)));
            }
            sourceSubscription.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryDrainIterator(Iterator<? extends U> currentIterator, PublisherSource.Subscription sourceSubscription, @Nullable TerminalNotification terminalNotification, long requestN, ErrorHandlingStrategyInDrain errorHandlingStrategyInDrain) {
            boolean hasNext = false;
            boolean terminated = false;
            while (emittingUpdater.compareAndSet(this, 0, 1)) {
                block30: {
                    Iterator<U> previousIterator;
                    long initialRequestN = requestN;
                    try {
                        try {
                            while ((hasNext = currentIterator.hasNext()) && requestN > 0L) {
                                --requestN;
                                this.target.onNext(currentIterator.next());
                            }
                        }
                        catch (Throwable cause) {
                            switch (errorHandlingStrategyInDrain) {
                                case PropagateAndCancel: {
                                    terminated = true;
                                    this.doCancel(sourceSubscription);
                                    try {
                                        this.target.onError(cause);
                                    }
                                    catch (Throwable cause2) {
                                        LOGGER.info("Ignoring exception from onError of Subscriber {}.", this.target, (Object)cause2);
                                    }
                                    break;
                                }
                                case Propagate: {
                                    terminated = true;
                                    this.target.onError(cause);
                                    break;
                                }
                                case Throw: {
                                    throw cause;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unknown error handling strategy: " + (Object)((Object)errorHandlingStrategyInDrain));
                                }
                            }
                        }
                        if (terminalNotification != null && !hasNext) {
                            terminated = true;
                            terminalNotification.terminate(this.target);
                        }
                        if ((requestN = requestNUpdater.accumulateAndGet(this, requestN - initialRequestN, FlowControlUtils::addWithOverflowProtectionIfNotNegative)) < 0L) {
                            terminated = true;
                            this.doCancel(sourceSubscription);
                            break block30;
                        }
                        if (terminated) break block30;
                    }
                    catch (Throwable throwable) {
                        requestN = requestNUpdater.accumulateAndGet(this, requestN - initialRequestN, FlowControlUtils::addWithOverflowProtectionIfNotNegative);
                        if (requestN < 0L) {
                            terminated = true;
                            this.doCancel(sourceSubscription);
                        } else if (!terminated) {
                            Iterator<U> previousIterator2;
                            try {
                                if (terminalNotification == null && !hasNext && requestN > 0L && currentIterator != EmptyIterator.instance()) {
                                    previousIterator2 = EmptyIterator.instance();
                                    this.currentIterator = previousIterator2;
                                    sourceSubscription.request(1L);
                                } else {
                                    previousIterator2 = currentIterator;
                                }
                            }
                            finally {
                                this.emitting = 0;
                            }
                            requestN = this.requestN;
                            currentIterator = this.currentIterator;
                            if (previousIterator2 != currentIterator) {
                                hasNext = requestN > 0L;
                            }
                        }
                        throw throwable;
                    }
                    try {
                        if (terminalNotification == null && !hasNext && requestN > 0L && currentIterator != EmptyIterator.instance()) {
                            previousIterator = EmptyIterator.instance();
                            this.currentIterator = previousIterator;
                            sourceSubscription.request(1L);
                        } else {
                            previousIterator = currentIterator;
                        }
                    }
                    finally {
                        this.emitting = 0;
                    }
                    requestN = this.requestN;
                    currentIterator = this.currentIterator;
                    if (previousIterator != currentIterator) {
                        hasNext = requestN > 0L;
                    }
                }
                if (!terminated && (requestN < 0L || requestN > 0L && hasNext || !hasNext && (terminalNotification = this.terminalNotification) != null)) continue;
            }
        }

        private static final class EmptyIterator<U>
        implements Iterator<U> {
            private static final EmptyIterator INSTANCE = new EmptyIterator();

            private EmptyIterator() {
            }

            static <T> EmptyIterator<T> instance() {
                return INSTANCE;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public U next() {
                throw new NoSuchElementException();
            }
        }

        private static enum ErrorHandlingStrategyInDrain {
            PropagateAndCancel,
            Propagate,
            Throw;

        }
    }
}

