/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractPubToSingle;
import io.servicetalk.concurrent.api.Publisher;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

final class PubFirstOrError<T>
extends AbstractPubToSingle<T> {
    PubFirstOrError(Publisher<T> source) {
        super(source.executor(), source);
    }

    @Override
    PublisherSource.Subscriber<T> newSubscriber(SingleSource.Subscriber<? super T> original) {
        return new AbstractPubToSingle.AbstractPubToSingleSubscriber<T>(original){
            @Nullable
            private Object lastValue;

            @Override
            int numberOfItemsToRequest() {
                return 2;
            }

            public void onNext(T t) {
                if (this.lastValue == null) {
                    this.lastValue = this.wrapNull(t);
                } else {
                    assert (this.subscription != null);
                    this.subscription.cancel();
                    this.terminate(new IllegalArgumentException("Only a single item expected, but saw the second value: " + t));
                }
            }

            @Override
            Object terminalSignalForComplete() {
                return this.lastValue == null ? new NoSuchElementException() : this.lastValue;
            }

            @Override
            void terminate(Object terminal) {
                try {
                    super.terminate(terminal);
                }
                finally {
                    this.lastValue = null;
                }
            }
        };
    }
}

