/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractMergeCompletableOperator;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.MergeCompletable;
import java.util.Collection;
import java.util.Objects;

final class IterableMergeCompletable
extends AbstractMergeCompletableOperator {
    private final Iterable<? extends Completable> others;
    private final boolean delayError;

    IterableMergeCompletable(boolean delayError, Completable original, Iterable<? extends Completable> others, Executor executor) {
        super(original, executor);
        this.delayError = delayError;
        this.others = Objects.requireNonNull(others);
    }

    @Override
    public AbstractMergeCompletableOperator.MergeSubscriber apply(CompletableSource.Subscriber subscriber) {
        if (this.others instanceof Collection) {
            return new MergeCompletable.FixedCountMergeSubscriber(subscriber, 1 + ((Collection)this.others).size(), this.delayError);
        }
        return new DynamicCountSubscriber(subscriber, this.delayError);
    }

    @Override
    void doMerge(AbstractMergeCompletableOperator.MergeSubscriber subscriber) {
        if (subscriber instanceof DynamicCountSubscriber) {
            int count = 1;
            for (Completable completable : this.others) {
                ++count;
                completable.subscribeInternal(subscriber);
            }
            ((DynamicCountSubscriber)subscriber).setExpectedCount(count);
        } else {
            for (Completable completable : this.others) {
                completable.subscribeInternal(subscriber);
            }
        }
    }

    private static final class DynamicCountSubscriber
    extends AbstractMergeCompletableOperator.MergeSubscriber {
        private volatile int expectedCount;

        DynamicCountSubscriber(CompletableSource.Subscriber subscriber, boolean delayError) {
            super(subscriber, delayError);
        }

        @Override
        boolean onTerminate() {
            return completedCountUpdater.incrementAndGet(this) == this.expectedCount;
        }

        @Override
        boolean isDone() {
            return this.completedCount == this.expectedCount;
        }

        void setExpectedCount(int count) {
            this.expectedCount = count;
            if (this.completedCount == count) {
                this.tryToCompleteSubscriber();
            }
        }
    }
}

