/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class DelegatingExecutor
implements Executor {
    final Executor delegate;

    public DelegatingExecutor(Executor delegate) {
        this.delegate = delegate;
    }

    public Cancellable execute(Runnable task) throws RejectedExecutionException {
        return this.delegate.execute(task);
    }

    public Cancellable schedule(Runnable task, long delay, TimeUnit unit) throws RejectedExecutionException {
        return this.delegate.schedule(task, delay, unit);
    }

    public Cancellable schedule(Runnable task, Duration delay) throws RejectedExecutionException {
        return this.delegate.schedule(task, delay);
    }

    @Override
    public Completable timer(long delay, TimeUnit unit) {
        return this.delegate.timer(delay, unit);
    }

    @Override
    public Completable timer(Duration delay) {
        return this.delegate.timer(delay);
    }

    @Override
    public Completable submit(Runnable runnable) {
        return this.delegate.submit(runnable);
    }

    @Override
    public Completable submitRunnable(Supplier<Runnable> runnableSupplier) {
        return this.delegate.submitRunnable(runnableSupplier);
    }

    @Override
    public <T> Single<T> submit(Callable<? extends T> callable) {
        return this.delegate.submit(callable);
    }

    @Override
    public <T> Single<T> submitCallable(Supplier<? extends Callable<? extends T>> callableSupplier) {
        return this.delegate.submitCallable(callableSupplier);
    }

    @Override
    public Completable onClose() {
        return this.delegate.onClose();
    }

    @Override
    public Completable closeAsync() {
        return this.delegate.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.delegate.closeAsyncGracefully();
    }
}

