/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.internal.TerminalNotification;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

final class DefaultBlockingIterableProcessor<T>
implements BlockingIterable.Processor<T> {
    private static final Object NULL_MASK = new Object();
    private final BlockingQueue<Object> buffer;
    @Nullable
    private TerminalNotification terminationReason;

    DefaultBlockingIterableProcessor(int maxBufferSize) {
        this.buffer = new LinkedBlockingQueue<Object>(maxBufferSize);
    }

    public BlockingIterator<T> iterator() {
        return new PollingBlockingIterator(this.buffer);
    }

    public void next(@Nullable T nextItem) throws Exception {
        this.verifyOpen("Can not emit items to a closed iterable.");
        this.buffer.put(DefaultBlockingIterableProcessor.maskNull(nextItem));
    }

    public void fail(Throwable cause) throws Exception {
        this.verifyOpen("Can not fail iterable that is already closed.");
        this.terminationReason = TerminalNotification.error((Throwable)cause);
        this.buffer.put(this.terminationReason);
    }

    public void close() throws Exception {
        this.verifyOpen("Iterable already closed.");
        this.terminationReason = TerminalNotification.complete();
        this.buffer.put(this.terminationReason);
    }

    private void verifyOpen(String s) {
        if (this.terminationReason != null) {
            if (this.terminationReason.cause() == null) {
                throw new IllegalStateException(s);
            }
            PlatformDependent.throwException((Throwable)this.terminationReason.cause());
        }
    }

    private static Object maskNull(@Nullable Object nextItem) {
        return nextItem == null ? NULL_MASK : nextItem;
    }

    private static final class PollingBlockingIterator<T>
    implements BlockingIterator<T> {
        @Nullable
        private Object next;
        @Nullable
        private TerminalNotification terminal;
        private final BlockingQueue<Object> buffer;

        PollingBlockingIterator(BlockingQueue<Object> buffer) {
            this.buffer = buffer;
        }

        public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
            Object next;
            if (this.terminal != null) {
                return this.hasNextWhenTerminated();
            }
            if (this.next != null) {
                return true;
            }
            try {
                next = this.buffer.poll(timeout, unit);
            }
            catch (InterruptedException e) {
                return (Boolean)PlatformDependent.throwException((Throwable)e);
            }
            if (next == null) {
                throw new TimeoutException("Timed out waiting for an item.");
            }
            return this.processHasNext(next);
        }

        @Nullable
        public T next(long timeout, TimeUnit unit) throws TimeoutException {
            if (!this.hasNext(timeout, unit)) {
                throw new NoSuchElementException();
            }
            return this.processNext();
        }

        @Nullable
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.processNext();
        }

        public void close() {
            this.terminal = TerminalNotification.error((Throwable)new CancellationException());
        }

        public boolean hasNext() {
            Object next;
            if (this.terminal != null) {
                return this.hasNextWhenTerminated();
            }
            if (this.next != null) {
                return true;
            }
            try {
                next = this.buffer.take();
            }
            catch (InterruptedException e) {
                return (Boolean)PlatformDependent.throwException((Throwable)e);
            }
            return this.processHasNext(next);
        }

        @Nullable
        private T processNext() {
            Object next = this.next;
            this.next = null;
            if (next == NULL_MASK) {
                return null;
            }
            Object t = next;
            return (T)t;
        }

        private boolean processHasNext(Object next) {
            if (next instanceof TerminalNotification) {
                this.terminal = (TerminalNotification)next;
                if (this.terminal.cause() == null) {
                    return false;
                }
                return (Boolean)PlatformDependent.throwException((Throwable)this.terminal.cause());
            }
            this.next = next;
            return true;
        }

        private boolean hasNextWhenTerminated() {
            assert (this.terminal != null);
            return this.terminal.cause() != null && (Boolean)PlatformDependent.throwException((Throwable)this.terminal.cause()) != false;
        }
    }
}

