/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CompletedCompletable
extends AbstractSynchronousCompletable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletedCompletable.class);
    static final CompletedCompletable INSTANCE = new CompletedCompletable();

    private CompletedCompletable() {
    }

    @Override
    void doSubscribe(CompletableSource.Subscriber subscriber) {
        try {
            subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe((CompletableSource.Subscriber)subscriber, (Throwable)t);
            return;
        }
        try {
            subscriber.onComplete();
        }
        catch (Throwable t) {
            LOGGER.info("Ignoring exception from onComplete of Subscriber {}.", (Object)subscriber, (Object)t);
        }
    }
}

