/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.OnSubscribeIgnoringSubscriberForOffloading;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class CompletableToPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Completable original;

    CompletableToPublisher(Completable original, Executor executor) {
        super(executor);
        this.original = original;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ConversionSubscriber(subscriber, signalOffloader), signalOffloader, contextMap, contextProvider);
    }

    private static final class ConversionSubscriber<T>
    extends SequentialCancellable
    implements CompletableSource.Subscriber,
    PublisherSource.Subscription {
        private static final AtomicIntegerFieldUpdater<ConversionSubscriber> terminatedUpdater = AtomicIntegerFieldUpdater.newUpdater(ConversionSubscriber.class, "terminated");
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final SignalOffloader signalOffloader;
        private volatile int terminated;

        private ConversionSubscriber(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader) {
            this.subscriber = subscriber;
            this.signalOffloader = signalOffloader;
        }

        public void onSubscribe(Cancellable cancellable) {
            this.nextCancellable(cancellable);
            this.subscriber.onSubscribe((PublisherSource.Subscription)this);
        }

        public void onComplete() {
            if (terminatedUpdater.compareAndSet(this, 0, 1)) {
                this.subscriber.onComplete();
            }
        }

        public void onError(Throwable t) {
            if (terminatedUpdater.compareAndSet(this, 0, 1)) {
                this.subscriber.onError(t);
            }
        }

        public void request(long n) {
            if (!SubscriberUtils.isRequestNValid((long)n) && terminatedUpdater.compareAndSet(this, 0, 1)) {
                PublisherSource.Subscriber<? super T> offloaded = OnSubscribeIgnoringSubscriberForOffloading.offloadWithDummyOnSubscribe(this.signalOffloader, this.subscriber);
                try {
                    this.cancel();
                }
                catch (Throwable t) {
                    offloaded.onError(t);
                    return;
                }
                offloaded.onError((Throwable)SubscriberUtils.newExceptionForInvalidRequestN((long)n));
            }
        }
    }
}

