/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.MergedCancellableWithSubscription;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.ConcurrentTerminalSubscriber;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.DelayedSubscription;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

final class CompletableMergeWithPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Completable original;
    private final Publisher<? extends T> mergeWith;

    CompletableMergeWithPublisher(Completable original, Publisher<? extends T> mergeWith, Executor executor) {
        super(executor);
        this.mergeWith = mergeWith;
        this.original = original;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        new Merger<T>(subscriber, signalOffloader, contextMap, contextProvider).merge(this.original, this.mergeWith, signalOffloader, contextMap, contextProvider);
    }

    private static final class Merger<T>
    implements PublisherSource.Subscriber<T> {
        private static final AtomicIntegerFieldUpdater<Merger> completionCountUpdater = AtomicIntegerFieldUpdater.newUpdater(Merger.class, "completionCount");
        private volatile int completionCount;
        private final CompletableSubscriber completableSubscriber;
        private final PublisherSource.Subscriber<? super T> offloadedSubscriber;
        private final DelayedSubscription subscription = new DelayedSubscription();

        Merger(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.offloadedSubscriber = new ConcurrentTerminalSubscriber(signalOffloader.offloadSubscriber(contextProvider.wrapPublisherSubscriber(subscriber, contextMap)), false);
            this.completableSubscriber = new CompletableSubscriber();
        }

        void merge(Completable original, Publisher<? extends T> mergeWith, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.offloadedSubscriber.onSubscribe((PublisherSource.Subscription)new MergedCancellableWithSubscription((PublisherSource.Subscription)this.subscription, (Cancellable)this.completableSubscriber));
            original.delegateSubscribe(this.completableSubscriber, signalOffloader, contextMap, contextProvider);
            mergeWith.subscribeInternal(this);
        }

        public void onSubscribe(PublisherSource.Subscription targetSubscription) {
            this.subscription.delayedSubscription((PublisherSource.Subscription)ConcurrentSubscription.wrap((PublisherSource.Subscription)targetSubscription));
        }

        public void onNext(@Nullable T t) {
            this.offloadedSubscriber.onNext(t);
        }

        public void onError(Throwable t) {
            this.completableSubscriber.cancel();
            this.offloadedSubscriber.onError(t);
        }

        public void onComplete() {
            if (completionCountUpdater.incrementAndGet(this) == 2) {
                this.offloadedSubscriber.onComplete();
            }
        }

        private final class CompletableSubscriber
        extends DelayedCancellable
        implements CompletableSource.Subscriber {
            private CompletableSubscriber() {
            }

            public void onSubscribe(Cancellable cancellable) {
                this.delayedCancellable(cancellable);
            }

            public void onComplete() {
                if (completionCountUpdater.incrementAndGet(Merger.this) == 2) {
                    Merger.this.offloadedSubscriber.onComplete();
                }
            }

            public void onError(Throwable t) {
                Merger.this.subscription.cancel();
                Merger.this.offloadedSubscriber.onError(t);
            }
        }
    }
}

