/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.function.Supplier;

final class CompletableDefer
extends Completable
implements CompletableSource {
    private final Supplier<? extends Completable> completableFactory;

    CompletableDefer(Supplier<? extends Completable> completableFactory) {
        this.completableFactory = Objects.requireNonNull(completableFactory);
    }

    @Override
    protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
        Completable completable;
        try {
            completable = Objects.requireNonNull(this.completableFactory.get());
        }
        catch (Throwable cause) {
            SubscriberUtils.deliverTerminalFromSource((CompletableSource.Subscriber)subscriber, (Throwable)cause);
            return;
        }
        completable.subscribeInternal(subscriber);
    }

    public void subscribe(CompletableSource.Subscriber subscriber) {
        this.subscribeInternal(subscriber);
    }
}

