/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractSynchronousSingleOperator;
import io.servicetalk.concurrent.api.BeforeCancellable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class BeforeFinallySingle<T>
extends AbstractSynchronousSingleOperator<T, T> {
    private final Runnable runnable;

    BeforeFinallySingle(Single<T> original, Runnable runnable, Executor executor) {
        super(original, executor);
        this.runnable = Objects.requireNonNull(runnable);
    }

    @Override
    public SingleSource.Subscriber<? super T> apply(SingleSource.Subscriber<? super T> subscriber) {
        return new BeforeFinallySingleSubscriber<T>(subscriber, this.runnable);
    }

    private static final class BeforeFinallySingleSubscriber<T>
    implements SingleSource.Subscriber<T> {
        private final SingleSource.Subscriber<? super T> original;
        private final Runnable runnable;
        private static final AtomicIntegerFieldUpdater<BeforeFinallySingleSubscriber> completeUpdater = AtomicIntegerFieldUpdater.newUpdater(BeforeFinallySingleSubscriber.class, "complete");
        private volatile int complete;

        BeforeFinallySingleSubscriber(SingleSource.Subscriber<? super T> original, Runnable runnable) {
            this.original = original;
            this.runnable = runnable;
        }

        public void onSubscribe(Cancellable originalCancellabe) {
            this.original.onSubscribe((Cancellable)new BeforeCancellable(this::beforeFinally, originalCancellabe));
        }

        public void onSuccess(T value) {
            try {
                this.beforeFinally();
            }
            catch (Throwable error) {
                this.original.onError(error);
                return;
            }
            this.original.onSuccess(value);
        }

        public void onError(Throwable cause) {
            try {
                this.beforeFinally();
            }
            catch (Throwable err) {
                err.addSuppressed(cause);
                this.original.onError(err);
                return;
            }
            this.original.onError(cause);
        }

        private void beforeFinally() {
            if (completeUpdater.compareAndSet(this, 0, 1)) {
                this.runnable.run();
            }
        }
    }
}

