/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractSynchronousSingleOperator;
import io.servicetalk.concurrent.api.BeforeCancellable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class AfterFinallySingle<T>
extends AbstractSynchronousSingleOperator<T, T> {
    private final Runnable runnable;

    AfterFinallySingle(Single<T> original, Runnable runnable, Executor executor) {
        super(original, executor);
        this.runnable = Objects.requireNonNull(runnable);
    }

    @Override
    public SingleSource.Subscriber<? super T> apply(SingleSource.Subscriber<? super T> subscriber) {
        return new AfterFinallySingleSubscriber<T>(subscriber, this.runnable);
    }

    private static final class AfterFinallySingleSubscriber<T>
    implements SingleSource.Subscriber<T> {
        private final SingleSource.Subscriber<? super T> original;
        private final Runnable runnable;
        private static final AtomicIntegerFieldUpdater<AfterFinallySingleSubscriber> completeUpdater = AtomicIntegerFieldUpdater.newUpdater(AfterFinallySingleSubscriber.class, "complete");
        private volatile int complete;

        AfterFinallySingleSubscriber(SingleSource.Subscriber<? super T> original, Runnable runnable) {
            this.original = original;
            this.runnable = runnable;
        }

        public void onSubscribe(Cancellable originalCancellable) {
            this.original.onSubscribe((Cancellable)new BeforeCancellable(originalCancellable, this::afterFinally));
        }

        public void onSuccess(T value) {
            try {
                this.original.onSuccess(value);
            }
            finally {
                this.afterFinally();
            }
        }

        public void onError(Throwable cause) {
            try {
                this.original.onError(cause);
            }
            finally {
                this.afterFinally();
            }
        }

        private void afterFinally() {
            if (completeUpdater.compareAndSet(this, 0, 1)) {
                this.runnable.run();
            }
        }
    }
}

