/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompletableOperator;
import io.servicetalk.concurrent.api.DynamicCompositeCancellable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.QueueDynamicCompositeCancellable;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

abstract class AbstractMergeCompletableOperator
extends AbstractNoHandleSubscribeCompletable
implements CompletableOperator {
    private final Completable original;

    AbstractMergeCompletableOperator(Completable original, Executor executor) {
        super(executor);
        this.original = Objects.requireNonNull(original);
    }

    @Override
    final void handleSubscribe(CompletableSource.Subscriber subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        CompletableSource.Subscriber operatorSubscriber = signalOffloader.offloadSubscriber(contextProvider.wrapCompletableSubscriberAndCancellable(subscriber, contextMap));
        MergeSubscriber mergeSubscriber = this.apply(operatorSubscriber);
        CompletableSource.Subscriber upstreamSubscriber = signalOffloader.offloadCancellable((CompletableSource.Subscriber)mergeSubscriber);
        this.original.delegateSubscribe(upstreamSubscriber, signalOffloader, contextMap, contextProvider);
        this.doMerge(mergeSubscriber);
    }

    @Override
    public abstract MergeSubscriber apply(CompletableSource.Subscriber var1);

    abstract void doMerge(MergeSubscriber var1);

    static abstract class MergeSubscriber
    implements CompletableSource.Subscriber {
        static final AtomicIntegerFieldUpdater<MergeSubscriber> completedCountUpdater = AtomicIntegerFieldUpdater.newUpdater(MergeSubscriber.class, "completedCount");
        private static final AtomicReferenceFieldUpdater<MergeSubscriber, Object> terminalNotificationUpdater = AtomicReferenceFieldUpdater.newUpdater(MergeSubscriber.class, Object.class, "terminalNotification");
        private static final Object ON_COMPLETE = new Object();
        private static final Object DELIVERED_DELAYED_ERROR = new Object();
        volatile int completedCount;
        @Nullable
        private volatile Object terminalNotification;
        private final CompletableSource.Subscriber subscriber;
        private final DynamicCompositeCancellable dynamicCancellable;
        private final boolean delayError;

        MergeSubscriber(CompletableSource.Subscriber subscriber, boolean delayError) {
            this.subscriber = subscriber;
            this.delayError = delayError;
            this.dynamicCancellable = new QueueDynamicCompositeCancellable();
            subscriber.onSubscribe((Cancellable)this.dynamicCancellable);
        }

        MergeSubscriber(CompletableSource.Subscriber subscriber, int completedCount, boolean delayError) {
            this.subscriber = subscriber;
            this.delayError = delayError;
            this.completedCount = completedCount;
            this.dynamicCancellable = new QueueDynamicCompositeCancellable();
            subscriber.onSubscribe((Cancellable)this.dynamicCancellable);
        }

        public final void onSubscribe(Cancellable cancellable) {
            this.dynamicCancellable.add(cancellable);
        }

        public final void onComplete() {
            if (this.onTerminate()) {
                this.tryToCompleteSubscriber();
            }
        }

        public final void onError(Throwable t) {
            block3: {
                Object terminalNotification;
                while ((terminalNotification = this.terminalNotification) == null) {
                    if (!terminalNotificationUpdater.compareAndSet(this, null, t)) {
                        if (this.delayError) continue;
                        return;
                    }
                    break block3;
                }
                Throwable tmpT = (Throwable)terminalNotification;
                tmpT.addSuppressed(t);
                t = tmpT;
            }
            if (!this.delayError || this.onTerminate() && t == terminalNotificationUpdater.getAndSet(this, DELIVERED_DELAYED_ERROR)) {
                this.onError0(t);
            }
        }

        final void tryToCompleteSubscriber() {
            Object maybeThrowable;
            if (terminalNotificationUpdater.compareAndSet(this, null, ON_COMPLETE)) {
                this.subscriber.onComplete();
            } else if (this.delayError && (maybeThrowable = terminalNotificationUpdater.getAndSet(this, DELIVERED_DELAYED_ERROR)) instanceof Throwable) {
                this.onError0((Throwable)maybeThrowable);
            }
        }

        private void onError0(Throwable t) {
            if (!this.delayError) {
                this.dynamicCancellable.cancel();
            }
            this.subscriber.onError(t);
        }

        abstract boolean onTerminate();

        abstract boolean isDone();
    }
}

