/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.CollectingPublisherSubscriber;
import io.servicetalk.concurrent.api.DemandCheckingSubscriber;
import io.servicetalk.concurrent.api.LoggingPublisherSubscriber;
import io.servicetalk.concurrent.internal.TerminalNotification;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TestPublisherSubscriber<T>
implements PublisherSource.Subscriber<T>,
PublisherSource.Subscription {
    private final CollectingPublisherSubscriber<T> collector;
    private final PublisherSource.Subscriber<T> delegate;

    public TestPublisherSubscriber() {
        this.collector = new CollectingPublisherSubscriber();
        this.delegate = new DemandCheckingSubscriber<T>(this.collector);
    }

    private TestPublisherSubscriber(CollectingPublisherSubscriber<T> collector, PublisherSource.Subscriber<T> delegate) {
        this.collector = collector;
        this.delegate = delegate;
    }

    public boolean subscriptionReceived() {
        return this.collector.subscriptionReceived();
    }

    public PublisherSource.Subscription subscription() {
        return this.collector.subscription();
    }

    public List<T> items() {
        return this.collector.items();
    }

    public List<T> takeItems() {
        return this.collector.takeItems();
    }

    @Nullable
    public TerminalNotification terminal() {
        return this.collector.terminal();
    }

    @Nullable
    public TerminalNotification takeTerminal() {
        return this.collector.takeTerminal();
    }

    @Nullable
    public Throwable error() {
        return this.collector.error();
    }

    @Nullable
    public Throwable takeError() {
        return this.collector.takeError();
    }

    public boolean isCompleted() {
        return this.collector.isCompleted();
    }

    public boolean isErrored() {
        return this.collector.isErrored();
    }

    public boolean isTerminated() {
        return this.collector.isTerminated();
    }

    public void request(long n) {
        this.collector.request(n);
    }

    public void cancel() {
        this.collector.cancel();
    }

    public void onSubscribe(PublisherSource.Subscription s) {
        this.delegate.onSubscribe(s);
    }

    public void onNext(T item) {
        this.delegate.onNext(item);
    }

    public void onError(Throwable t) {
        this.delegate.onError(t);
    }

    public void onComplete() {
        this.delegate.onComplete();
    }

    private static final class DoubleDelegatingSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<T> first;
        private final PublisherSource.Subscriber<T> second;

        DoubleDelegatingSubscriber(PublisherSource.Subscriber<T> first, PublisherSource.Subscriber<T> second) {
            this.first = Objects.requireNonNull(first);
            this.second = Objects.requireNonNull(second);
        }

        public void onSubscribe(PublisherSource.Subscription subscription) {
            try {
                this.first.onSubscribe(subscription);
            }
            finally {
                this.second.onSubscribe(subscription);
            }
        }

        public void onNext(@Nullable T t) {
            try {
                this.first.onNext(t);
            }
            finally {
                this.second.onNext(t);
            }
        }

        public void onError(Throwable t) {
            try {
                this.first.onError(t);
            }
            finally {
                this.second.onError(t);
            }
        }

        public void onComplete() {
            try {
                this.first.onComplete();
            }
            finally {
                this.second.onComplete();
            }
        }
    }

    public static class Builder<T> {
        private boolean checkDemand = true;
        @Nullable
        private String loggingName;
        @Nullable
        private PublisherSource.Subscriber<T> subscriber;

        public Builder<T> lastSubscriber(PublisherSource.Subscriber<T> subscriber) {
            this.subscriber = subscriber;
            return this;
        }

        public Builder<T> enableDemandCheck() {
            this.checkDemand = true;
            return this;
        }

        public Builder<T> disableDemandCheck() {
            this.checkDemand = false;
            return this;
        }

        public Builder<T> enableLogging() {
            return this.enableLogging(TestPublisherSubscriber.class.getName());
        }

        public Builder<T> enableLogging(String loggingName) {
            this.loggingName = Objects.requireNonNull(loggingName);
            return this;
        }

        public Builder<T> disableLogging() {
            this.loggingName = null;
            return this;
        }

        public TestPublisherSubscriber<T> build() {
            CollectingPublisherSubscriber collector;
            Object delegate = collector = new CollectingPublisherSubscriber();
            if (this.subscriber != null) {
                delegate = new DoubleDelegatingSubscriber(delegate, this.subscriber);
            }
            if (this.checkDemand) {
                delegate = new DemandCheckingSubscriber(delegate);
            }
            if (this.loggingName != null) {
                delegate = new LoggingPublisherSubscriber(this.loggingName, delegate);
            }
            return new TestPublisherSubscriber(collector, (PublisherSource.Subscriber)delegate);
        }
    }
}

