/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public class TestIterableToBlockingIterable<T>
implements BlockingIterable<T> {
    private final Iterable<T> iterable;
    private final BiConsumer<Long, TimeUnit> hashNextConsumer;
    private final BiConsumer<Long, TimeUnit> nextConsumer;
    private final AutoCloseable closeable;

    public TestIterableToBlockingIterable(Iterable<T> iterable, BiConsumer<Long, TimeUnit> hashNextConsumer, BiConsumer<Long, TimeUnit> nextConsumer, AutoCloseable closeable) {
        this.iterable = Objects.requireNonNull(iterable);
        this.hashNextConsumer = hashNextConsumer;
        this.nextConsumer = nextConsumer;
        this.closeable = closeable;
    }

    public BlockingIterator<T> iterator() {
        return new TestIteratorToBlockingIterator<T>(this, this.iterable.iterator());
    }

    private static final class TestIteratorToBlockingIterator<T>
    implements BlockingIterator<T> {
        private final Iterator<T> iterator;
        private final TestIterableToBlockingIterable<T> iterable;

        TestIteratorToBlockingIterator(TestIterableToBlockingIterable<T> iterable, Iterator<T> iterator) {
            this.iterable = iterable;
            this.iterator = Objects.requireNonNull(iterator);
        }

        public boolean hasNext(long timeout, TimeUnit unit) {
            ((TestIterableToBlockingIterable)this.iterable).hashNextConsumer.accept(timeout, unit);
            return this.iterator.hasNext();
        }

        public T next(long timeout, TimeUnit unit) {
            ((TestIterableToBlockingIterable)this.iterable).nextConsumer.accept(timeout, unit);
            return this.iterator.next();
        }

        public void close() throws Exception {
            ((TestIterableToBlockingIterable)this.iterable).closeable.close();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public T next() {
            return this.iterator.next();
        }
    }
}

