/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.CollectingCompletableSubscriber;
import io.servicetalk.concurrent.api.LoggingCompletableSubscriber;
import io.servicetalk.concurrent.internal.TerminalNotification;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TestCompletableSubscriber
implements CompletableSource.Subscriber,
Cancellable {
    private final CollectingCompletableSubscriber collector;
    private final CompletableSource.Subscriber delegate;

    public TestCompletableSubscriber() {
        this.collector = new CollectingCompletableSubscriber();
        this.delegate = this.collector;
    }

    private TestCompletableSubscriber(CollectingCompletableSubscriber collector, CompletableSource.Subscriber delegate) {
        this.collector = collector;
        this.delegate = delegate;
    }

    public boolean cancellableReceived() {
        return this.collector.cancellableReceived();
    }

    public Cancellable cancellable() {
        return this.collector.cancellable();
    }

    @Nullable
    public TerminalNotification terminal() {
        return this.collector.terminal();
    }

    @Nullable
    public TerminalNotification takeTerminal() {
        return this.collector.takeTerminal();
    }

    @Nullable
    public Throwable error() {
        return this.collector.error();
    }

    @Nullable
    public Throwable takeError() {
        return this.collector.takeError();
    }

    public boolean isCompleted() {
        return this.collector.isCompleted();
    }

    public boolean isErrored() {
        return this.collector.isErrored();
    }

    public boolean isTerminated() {
        return this.collector.isTerminated();
    }

    public void cancel() {
        this.collector.cancel();
    }

    public void onSubscribe(Cancellable s) {
        this.delegate.onSubscribe(s);
    }

    public void onComplete() {
        this.delegate.onComplete();
    }

    public void onError(Throwable t) {
        this.delegate.onError(t);
    }

    public static class Builder {
        @Nullable
        private String loggingName;

        public Builder enableLogging() {
            return this.enableLogging(TestCompletableSubscriber.class.getName());
        }

        public Builder enableLogging(String loggingName) {
            this.loggingName = Objects.requireNonNull(loggingName);
            return this;
        }

        public Builder disableLogging() {
            this.loggingName = null;
            return this;
        }

        public TestCompletableSubscriber build() {
            CollectingCompletableSubscriber collector;
            Object delegate = collector = new CollectingCompletableSubscriber();
            if (this.loggingName != null) {
                delegate = new LoggingCompletableSubscriber(this.loggingName, (CompletableSource.Subscriber)delegate);
            }
            return new TestCompletableSubscriber(collector, (CompletableSource.Subscriber)delegate);
        }
    }
}

