/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.DelegatingPublisherSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class SequentialPublisherSubscriberFunction<T>
implements Function<PublisherSource.Subscriber<? super T>, PublisherSource.Subscriber<? super T>> {
    private final AtomicBoolean subscribed = new AtomicBoolean();
    @Nullable
    private volatile PublisherSource.Subscriber<? super T> subscriber;

    @Override
    public PublisherSource.Subscriber<? super T> apply(final PublisherSource.Subscriber<? super T> subscriber) {
        if (!this.subscribed.compareAndSet(false, true)) {
            throw new IllegalStateException("Duplicate subscriber: " + subscriber);
        }
        this.subscriber = subscriber;
        return new DelegatingPublisherSubscriber<T>(subscriber){

            @Override
            public void onSubscribe(final PublisherSource.Subscription s) {
                super.onSubscribe(new PublisherSource.Subscription(){

                    public void request(long n) {
                        s.request(n);
                    }

                    public void cancel() {
                        this.reset(subscriber);
                        s.cancel();
                    }
                });
            }

            @Override
            public void onError(Throwable t) {
                this.reset(subscriber);
                super.onError(t);
            }

            @Override
            public void onComplete() {
                this.reset(subscriber);
                super.onComplete();
            }

            private void reset(PublisherSource.Subscriber<? super T> subscriber2) {
                if (SequentialPublisherSubscriberFunction.this.subscriber == subscriber2) {
                    SequentialPublisherSubscriberFunction.this.subscribed.set(false);
                }
            }
        };
    }

    @Nullable
    public PublisherSource.Subscriber<? super T> subscriber() {
        return this.subscriber;
    }

    public boolean isSubscribed() {
        return this.subscribed.get();
    }
}

