/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPublisherSubscriber<T>
implements PublisherSource.Subscriber<T> {
    private final Logger logger;
    private final PublisherSource.Subscriber<T> delegate;

    public LoggingPublisherSubscriber(String name, PublisherSource.Subscriber<T> delegate) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.delegate = delegate;
    }

    public void onSubscribe(final PublisherSource.Subscription s) {
        this.logger.info("onSubscribe({})", (Object)s);
        this.delegate.onSubscribe(new PublisherSource.Subscription(){

            public void request(long n) {
                LoggingPublisherSubscriber.this.logger.info("request({})", (Object)n);
                s.request(n);
            }

            public void cancel() {
                LoggingPublisherSubscriber.this.logger.info("cancel()");
                s.cancel();
            }
        });
    }

    public void onNext(T t) {
        this.logger.info("onNext({})", t);
        this.delegate.onNext(t);
    }

    public void onError(Throwable t) {
        this.logger.info("onError({})", (Object)t, null);
        this.delegate.onError(t);
    }

    public void onComplete() {
        this.logger.info("onComplete()");
        this.delegate.onComplete();
    }
}

